/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.lib.output.PathOutputCommitterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractS3ACommitterFactory
extends PathOutputCommitterFactory {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractS3ACommitterFactory.class);

    public PathOutputCommitter createOutputCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        FileSystem fs = this.getDestinationFileSystem(outputPath, (JobContext)context);
        if (!(fs instanceof S3AFileSystem)) {
            throw new PathCommitException(outputPath, "Filesystem not supported by this committer");
        }
        PathOutputCommitter outputCommitter = this.createTaskCommitter((S3AFileSystem)fs, outputPath, context);
        LOG.info("Using Commmitter {} for {}", (Object)outputCommitter, (Object)outputPath);
        return outputCommitter;
    }

    protected FileSystem getDestinationFileSystem(Path outputPath, JobContext context) throws IOException {
        return outputPath != null ? FileSystem.get(outputPath.toUri(), context.getConfiguration()) : null;
    }

    public abstract PathOutputCommitter createTaskCommitter(S3AFileSystem var1, Path var2, TaskAttemptContext var3) throws IOException;
}

