/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import java.io.IOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.commons.lang3.StringUtils;

public enum S3AEncryptionMethods {
    SSE_S3("AES256"),
    SSE_KMS("SSE-KMS"),
    SSE_C("SSE-C"),
    NONE("");

    static final String UNKNOWN_ALGORITHM = "Unknown Server Side Encryption algorithm ";
    private String method;

    private S3AEncryptionMethods(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public static S3AEncryptionMethods getMethod(String name) throws IOException {
        if (StringUtils.isBlank(name)) {
            return NONE;
        }
        switch (name) {
            case "AES256": {
                return SSE_S3;
            }
            case "SSE-KMS": {
                return SSE_KMS;
            }
            case "SSE-C": {
                return SSE_C;
            }
        }
        throw new IOException(UNKNOWN_ALGORITHM + name);
    }
}

