/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTimestampUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import parquet.column.ColumnDescriptor;
import parquet.io.api.Binary;

public class ParquetTimestampColumnReader
extends ParquetColumnReader {
    public ParquetTimestampColumnReader(ColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            type.writeLong(blockBuilder, ParquetTimestampUtils.getTimestampMillis(binary));
        } else {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

