/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.HdfsParquetDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTimestampUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTypeUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate.ParquetPredicateUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.DecimalUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.RecordCursor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilderStatus;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.TupleDomain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Chars;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DecimalType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Decimals;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TimestampType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Varchars;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.InputSplit;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptID;
import parquet.column.ColumnDescriptor;
import parquet.column.Dictionary;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.io.api.RecordMaterializer;
import parquet.schema.DecimalMetadata;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;

public class ParquetHiveRecordCursor
implements RecordCursor {
    private final ParquetRecordReader<FakeParquetRecord> recordReader;
    private final Type[] types;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;
    private final long totalBytes;
    private long completedBytes;
    private boolean closed;

    public ParquetHiveRecordCursor(HdfsEnvironment hdfsEnvironment, String sessionUser, Configuration configuration, Path path, long start, long length, long fileSize, Properties splitSchema, List<HiveColumnHandle> columns, boolean useParquetColumnNames, TypeManager typeManager, boolean predicatePushdownEnabled, TupleDomain<HiveColumnHandle> effectivePredicate) {
        Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument(length >= 0L, "length is negative");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        this.totalBytes = length;
        int size = columns.size();
        this.types = new Type[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            Preconditions.checkState(column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR, "column type must be regular");
            this.types[columnIndex] = typeManager.getType(column.getTypeSignature());
        }
        this.recordReader = this.createParquetRecordReader(hdfsEnvironment, sessionUser, configuration, path, start, length, fileSize, columns, useParquetColumnNames, predicatePushdownEnabled, effectivePredicate);
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException newCompletedBytes) {
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            Arrays.fill(this.nulls, true);
            if (this.closed || !this.recordReader.nextKeyValue()) {
                this.close();
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException | RuntimeException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            HiveUtil.closeWithSuppression(this, e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        return this.booleans[fieldId];
    }

    public long getLong(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        return this.longs[fieldId];
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        return this.doubles[fieldId];
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Slice.class);
        return this.slices[fieldId];
    }

    public Object getObject(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Block.class);
        return this.objects[fieldId];
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        return this.nulls[fieldId];
    }

    private void validateType(int fieldId, Class<?> javaType) {
        if (this.types[fieldId].getJavaType() != javaType) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", javaType.getName(), this.types[fieldId].getJavaType().getName(), fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private ParquetRecordReader<FakeParquetRecord> createParquetRecordReader(HdfsEnvironment hdfsEnvironment, String sessionUser, Configuration configuration, Path path, long start, long length, long fileSize, List<HiveColumnHandle> columns, boolean useParquetColumnNames, boolean predicatePushdownEnabled, TupleDomain<HiveColumnHandle> effectivePredicate) {
        ParquetDataSource dataSource = null;
        try {
            FileSystem fileSystem = hdfsEnvironment.getFileSystem(sessionUser, path, configuration);
            dataSource = HdfsParquetDataSource.buildHdfsParquetDataSource(fileSystem, path, start, length, fileSize);
            ParquetMetadata parquetMetadata = hdfsEnvironment.doAs(sessionUser, () -> ParquetFileReader.readFooter((Configuration)configuration, (Path)path, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER));
            List blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            PrestoReadSupport readSupport = new PrestoReadSupport(useParquetColumnNames, columns, fileSchema);
            List fields = columns.stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedSchema = new MessageType(fileSchema.getName(), fields);
            LongArrayList offsets = new LongArrayList(blocks.size());
            for (BlockMetaData block : blocks) {
                long firstDataPage = ((ColumnChunkMetaData)block.getColumns().get(0)).getFirstDataPageOffset();
                if (firstDataPage < start || firstDataPage >= start + length) continue;
                if (predicatePushdownEnabled) {
                    TupleDomain<ColumnDescriptor> parquetTupleDomain = ParquetPredicateUtils.getParquetTupleDomain(fileSchema, requestedSchema, effectivePredicate);
                    ParquetPredicate parquetPredicate = ParquetPredicateUtils.buildParquetPredicate(requestedSchema, parquetTupleDomain, fileSchema);
                    if (!ParquetPredicateUtils.predicateMatches(parquetPredicate, block, dataSource, fileSchema, requestedSchema, parquetTupleDomain)) continue;
                    offsets.add(block.getStartingPos());
                    continue;
                }
                offsets.add(block.getStartingPos());
            }
            ParquetInputSplit split = new ParquetInputSplit(path, start, start + length, length, null, offsets.toLongArray());
            TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)configuration, (TaskAttemptID)new TaskAttemptID());
            ParquetRecordReader parquetRecordReader = hdfsEnvironment.doAs(sessionUser, () -> {
                PrestoParquetRecordReader realReader = new PrestoParquetRecordReader(readSupport);
                realReader.initialize((InputSplit)split, taskContext);
                return realReader;
            });
            return parquetRecordReader;
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf(e, PrestoException.class);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate(e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, e.getMessage());
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
        finally {
            if (dataSource != null) {
                try {
                    dataSource.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static BlockConverter createConverter(Type prestoType, String columnName, parquet.schema.Type parquetType, int fieldIndex) {
        if (parquetType.isPrimitive()) {
            if (parquetType.getOriginalType() == OriginalType.DECIMAL) {
                DecimalMetadata decimalMetadata = ((PrimitiveType)parquetType).getDecimalMetadata();
                return new ParquetDecimalConverter(DecimalType.createDecimalType((int)decimalMetadata.getPrecision(), (int)decimalMetadata.getScale()));
            }
            return new ParquetPrimitiveConverter(prestoType, fieldIndex);
        }
        return ParquetHiveRecordCursor.createGroupConverter(prestoType, columnName, parquetType, fieldIndex);
    }

    private static GroupedConverter createGroupConverter(Type prestoType, String columnName, parquet.schema.Type parquetType, int fieldIndex) {
        GroupType groupType = parquetType.asGroupType();
        switch (prestoType.getTypeSignature().getBase()) {
            case "array": {
                return new ParquetListConverter(prestoType, columnName, groupType, fieldIndex);
            }
            case "map": {
                return new ParquetMapConverter(prestoType, columnName, groupType, fieldIndex);
            }
            case "row": {
                return new ParquetStructConverter(prestoType, columnName, groupType, fieldIndex);
            }
        }
        throw new IllegalArgumentException("Column " + columnName + " type " + parquetType.getOriginalType() + " not supported");
    }

    private static class ParquetDecimalConverter
    extends PrimitiveConverter
    implements BlockConverter {
        private final DecimalType decimalType;
        private BlockBuilder builder;
        private boolean wroteValue;

        public ParquetDecimalConverter(DecimalType decimalType) {
            this.decimalType = Objects.requireNonNull(decimalType, "decimalType is null");
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "parent builder is null");
            this.wroteValue = false;
        }

        @Override
        public void afterValue() {
            if (this.wroteValue) {
                return;
            }
            this.builder.appendNull();
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void addBinary(Binary value) {
            if (this.decimalType.isShort()) {
                this.decimalType.writeLong(this.builder, DecimalUtils.getShortDecimalValue(value.getBytes()));
            } else {
                BigInteger unboundedDecimal = new BigInteger(value.getBytes());
                this.decimalType.writeSlice(this.builder, Decimals.encodeUnscaledValue((BigInteger)unboundedDecimal));
            }
            this.wroteValue = true;
        }
    }

    private static class ParquetPrimitiveConverter
    extends PrimitiveConverter
    implements BlockConverter {
        private final Type type;
        private final int fieldIndex;
        private BlockBuilder builder;

        public ParquetPrimitiveConverter(Type type, int fieldIndex) {
            this.type = type;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = Objects.requireNonNull(builder, "parent builder is null");
        }

        @Override
        public void afterValue() {
        }

        private void addMissingValues() {
            while (this.builder.getPositionCount() < this.fieldIndex) {
                this.builder.appendNull();
            }
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            this.addMissingValues();
            this.type.writeBoolean(this.builder, value);
        }

        public void addDouble(double value) {
            this.addMissingValues();
            this.type.writeDouble(this.builder, value);
        }

        public void addLong(long value) {
            this.addMissingValues();
            this.type.writeLong(this.builder, value);
        }

        public void addBinary(Binary value) {
            this.addMissingValues();
            if (this.type == TimestampType.TIMESTAMP) {
                this.type.writeLong(this.builder, ParquetTimestampUtils.getTimestampMillis(value));
            } else if (Varchars.isVarcharType((Type)this.type)) {
                this.type.writeSlice(this.builder, Varchars.truncateToLength((Slice)Slices.wrappedBuffer(value.getBytes()), (Type)this.type));
            } else if (Chars.isCharType((Type)this.type)) {
                this.type.writeSlice(this.builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.wrappedBuffer(value.getBytes()), (Type)this.type));
            } else {
                this.type.writeSlice(this.builder, Slices.wrappedBuffer(value.getBytes()));
            }
        }

        public void addFloat(float value) {
            this.addMissingValues();
            this.type.writeLong(this.builder, (long)Float.floatToRawIntBits(value));
        }

        public void addInt(int value) {
            this.addMissingValues();
            this.type.writeLong(this.builder, (long)value);
        }
    }

    private static class ParquetMapEntryConverter
    extends GroupConverter
    implements BlockConverter {
        private final BlockConverter keyConverter;
        private final BlockConverter valueConverter;
        private BlockBuilder builder;

        public ParquetMapEntryConverter(Type prestoType, String columnName, GroupType entryType) {
            GroupType entryGroupType;
            Preconditions.checkArgument("map".equals(prestoType.getTypeSignature().getBase()));
            if (entryType.getOriginalType() != null) {
                Preconditions.checkArgument(entryType.getOriginalType() == OriginalType.MAP_KEY_VALUE, "Expected MAP column '%s' field to be type %s, but is %s", (Object)columnName, (Object)OriginalType.MAP_KEY_VALUE, (Object)entryType);
            }
            Preconditions.checkArgument((entryGroupType = entryType.asGroupType()).getFieldCount() == 2, "Expected MAP column '%s' entry to have two fields, but has %s fields", (Object)columnName, entryGroupType.getFieldCount());
            Preconditions.checkArgument(entryGroupType.getFieldName(0).equals("key"), "Expected MAP column '%s' entry field 0 to be named 'key', but is named %s", (Object)columnName, (Object)entryGroupType.getFieldName(0));
            Preconditions.checkArgument(entryGroupType.getFieldName(1).equals("value"), "Expected MAP column '%s' entry field 1 to be named 'value', but is named %s", (Object)columnName, (Object)entryGroupType.getFieldName(1));
            Preconditions.checkArgument(entryGroupType.getType(0).isPrimitive(), "Expected MAP column '%s' entry field 0 to be primitive, but is %s", (Object)columnName, (Object)entryGroupType.getType(0));
            this.keyConverter = ParquetHiveRecordCursor.createConverter((Type)prestoType.getTypeParameters().get(0), columnName + ".key", (parquet.schema.Type)entryGroupType.getFields().get(0), 0);
            this.valueConverter = ParquetHiveRecordCursor.createConverter((Type)prestoType.getTypeParameters().get(1), columnName + ".value", (parquet.schema.Type)entryGroupType.getFields().get(1), 1);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.keyConverter;
            }
            if (fieldIndex == 1) {
                return (Converter)this.valueConverter;
            }
            throw new IllegalArgumentException("Map entry field must be 0 or 1 not " + fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            this.keyConverter.beforeValue(this.builder);
            this.valueConverter.beforeValue(this.builder);
        }

        public void end() {
            this.keyConverter.afterValue();
            this.valueConverter.afterValue();
            if (this.builder.getPositionCount() % 2 != 0) {
                this.builder.appendNull();
            }
        }

        @Override
        public void afterValue() {
        }
    }

    private static class ParquetMapConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final Type mapType;
        private final int fieldIndex;
        private final ParquetMapEntryConverter entryConverter;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetMapConverter(Type type, String columnName, GroupType mapType, int fieldIndex) {
            Preconditions.checkArgument(mapType.getFieldCount() == 1, "Expected MAP column '%s' to only have one field, but has %s fields", (Object)mapType.getName(), mapType.getFieldCount());
            this.mapType = type;
            this.fieldIndex = fieldIndex;
            parquet.schema.Type entryType = (parquet.schema.Type)mapType.getFields().get(0);
            this.entryConverter = new ParquetMapEntryConverter(type, columnName + ".entry", entryType.asGroupType());
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.entryConverter;
            }
            throw new IllegalArgumentException("Map field must be 0 not " + fieldIndex);
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768L) {
                    this.nullBuilder = this.mapType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                while (this.builder.getPositionCount() < this.fieldIndex) {
                    this.builder.appendNull();
                }
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            this.entryConverter.beforeValue(this.currentEntryBuilder);
        }

        public void end() {
            this.entryConverter.afterValue();
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState(this.builder == null && this.nullBuilder != null);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static class ParquetListEntryConverter
    extends GroupConverter
    implements BlockConverter {
        private final BlockConverter elementConverter;
        private BlockBuilder builder;
        private int startingPosition;

        public ParquetListEntryConverter(Type prestoType, String columnName, GroupType elementType) {
            Preconditions.checkArgument(elementType.getOriginalType() == null, "Expected LIST column '%s' field to be type STRUCT, but is %s", (Object)columnName, (Object)elementType);
            Preconditions.checkArgument(elementType.getFieldCount() == 1, "Expected LIST column '%s' element to have one field, but has %s fields", (Object)columnName, elementType.getFieldCount());
            this.elementConverter = ParquetHiveRecordCursor.createConverter(prestoType, columnName + ".element", elementType.getType(0), 0);
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST entry field must be 0 not " + fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            this.elementConverter.beforeValue(this.builder);
            this.startingPosition = this.builder.getPositionCount();
        }

        public void end() {
            this.elementConverter.afterValue();
            if (this.builder.getPositionCount() == this.startingPosition) {
                this.builder.appendNull();
            }
        }

        @Override
        public void afterValue() {
        }
    }

    private static class ParquetListConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final Type arrayType;
        private final int fieldIndex;
        private final BlockConverter elementConverter;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetListConverter(Type prestoType, String columnName, GroupType listType, int fieldIndex) {
            Preconditions.checkArgument(listType.getFieldCount() == 1, "Expected LIST column '%s' to only have one field, but has %s fields", (Object)columnName, listType.getFieldCount());
            Preconditions.checkArgument("array".equals(prestoType.getTypeSignature().getBase()));
            this.arrayType = prestoType;
            this.fieldIndex = fieldIndex;
            parquet.schema.Type elementType = listType.getType(0);
            this.elementConverter = this.isElementType(elementType, listType.getName()) ? ParquetHiveRecordCursor.createConverter((Type)prestoType.getTypeParameters().get(0), columnName + ".element", elementType, 0) : new ParquetListEntryConverter((Type)prestoType.getTypeParameters().get(0), columnName, elementType.asGroupType());
        }

        private boolean isElementType(parquet.schema.Type repeatedType, String parentName) {
            if (repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1) {
                return true;
            }
            if (repeatedType.getName().equals("array")) {
                return true;
            }
            return repeatedType.getName().equals(parentName + "_tuple");
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return (Converter)this.elementConverter;
            }
            throw new IllegalArgumentException("LIST field must be 0 not " + fieldIndex);
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768L) {
                    this.nullBuilder = this.arrayType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                while (this.builder.getPositionCount() < this.fieldIndex) {
                    this.builder.appendNull();
                }
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            this.elementConverter.beforeValue(this.currentEntryBuilder);
        }

        public void end() {
            this.elementConverter.afterValue();
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState(this.builder == null && this.nullBuilder != null);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static class ParquetStructConverter
    extends GroupedConverter {
        private static final int NULL_BUILDER_POSITIONS_THRESHOLD = 100;
        private static final int NULL_BUILDER_SIZE_IN_BYTES_THRESHOLD = 32768;
        private final Type rowType;
        private final int fieldIndex;
        private final List<BlockConverter> converters;
        private BlockBuilder builder;
        private BlockBuilder nullBuilder;
        private BlockBuilder currentEntryBuilder;

        public ParquetStructConverter(Type prestoType, String columnName, GroupType entryType, int fieldIndex) {
            Preconditions.checkArgument("row".equals(prestoType.getTypeSignature().getBase()));
            List prestoTypeParameters = prestoType.getTypeParameters();
            List fieldTypes = entryType.getFields();
            Preconditions.checkArgument(prestoTypeParameters.size() == fieldTypes.size(), "Schema mismatch, metastore schema for row column %s has %s fields but parquet schema has %s fields", (Object)columnName, (Object)prestoTypeParameters.size(), (Object)fieldTypes.size());
            this.rowType = prestoType;
            this.fieldIndex = fieldIndex;
            ImmutableList.Builder converters = ImmutableList.builder();
            for (int i = 0; i < prestoTypeParameters.size(); ++i) {
                parquet.schema.Type fieldType = (parquet.schema.Type)fieldTypes.get(i);
                converters.add(ParquetHiveRecordCursor.createConverter((Type)prestoTypeParameters.get(i), columnName + "." + fieldType.getName(), fieldType, i));
            }
            this.converters = converters.build();
        }

        public Converter getConverter(int fieldIndex) {
            return (Converter)this.converters.get(fieldIndex);
        }

        @Override
        public void beforeValue(BlockBuilder builder) {
            this.builder = builder;
        }

        public void start() {
            if (this.builder == null) {
                if (this.nullBuilder == null || this.nullBuilder.getPositionCount() >= 100 && this.nullBuilder.getSizeInBytes() >= 32768L) {
                    this.nullBuilder = this.rowType.createBlockBuilder(new BlockBuilderStatus(), 100);
                }
                this.currentEntryBuilder = this.nullBuilder.beginBlockEntry();
            } else {
                while (this.builder.getPositionCount() < this.fieldIndex) {
                    this.builder.appendNull();
                }
                this.currentEntryBuilder = this.builder.beginBlockEntry();
            }
            for (BlockConverter converter : this.converters) {
                converter.beforeValue(this.currentEntryBuilder);
            }
        }

        public void end() {
            for (BlockConverter converter : this.converters) {
                converter.afterValue();
            }
            while (this.currentEntryBuilder.getPositionCount() < this.converters.size()) {
                this.currentEntryBuilder.appendNull();
            }
            if (this.builder == null) {
                this.nullBuilder.closeEntry();
            } else {
                this.builder.closeEntry();
            }
        }

        @Override
        public void afterValue() {
        }

        @Override
        public Block getBlock() {
            Preconditions.checkState(this.builder == null && this.nullBuilder != null);
            return (Block)this.nullBuilder.getObject(this.nullBuilder.getPositionCount() - 1, Block.class);
        }
    }

    private static abstract class GroupedConverter
    extends GroupConverter
    implements BlockConverter {
        private GroupedConverter() {
        }

        public abstract Block getBlock();
    }

    private static interface BlockConverter {
        public void beforeValue(BlockBuilder var1);

        public void afterValue();
    }

    public class ParquetColumnConverter
    extends GroupConverter {
        private final GroupedConverter groupedConverter;
        private final int fieldIndex;

        public ParquetColumnConverter(GroupedConverter groupedConverter, int fieldIndex) {
            this.groupedConverter = groupedConverter;
            this.fieldIndex = fieldIndex;
        }

        public Converter getConverter(int fieldIndex) {
            return this.groupedConverter.getConverter(fieldIndex);
        }

        public void start() {
            this.groupedConverter.beforeValue(null);
            this.groupedConverter.start();
        }

        public void end() {
            this.groupedConverter.afterValue();
            this.groupedConverter.end();
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).objects[this.fieldIndex] = this.groupedConverter.getBlock();
        }
    }

    private class ParquetDecimalColumnConverter
    extends PrimitiveConverter {
        private final int fieldIndex;
        private final DecimalType decimalType;

        private ParquetDecimalColumnConverter(int fieldIndex, DecimalType decimalType) {
            this.fieldIndex = fieldIndex;
            this.decimalType = Objects.requireNonNull(decimalType, "decimalType is null");
        }

        public void addBinary(Binary value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            if (this.decimalType.isShort()) {
                ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = DecimalUtils.getShortDecimalValue(value.getBytes());
            } else {
                ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).slices[this.fieldIndex] = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(value.getBytes()));
            }
        }
    }

    private class ParquetPrimitiveColumnConverter
    extends PrimitiveConverter {
        private final int fieldIndex;

        private ParquetPrimitiveColumnConverter(int fieldIndex) {
            this.fieldIndex = fieldIndex;
        }

        public boolean isPrimitive() {
            return true;
        }

        public PrimitiveConverter asPrimitiveConverter() {
            return this;
        }

        public boolean hasDictionarySupport() {
            return false;
        }

        public void setDictionary(Dictionary dictionary) {
        }

        public void addValueFromDictionary(int dictionaryId) {
        }

        public void addBoolean(boolean value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).booleans[this.fieldIndex] = value;
        }

        public void addDouble(double value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).doubles[this.fieldIndex] = value;
        }

        public void addLong(long value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }

        public void addBinary(Binary value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            Type type = ParquetHiveRecordCursor.this.types[this.fieldIndex];
            if (type == TimestampType.TIMESTAMP) {
                ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = ParquetTimestampUtils.getTimestampMillis(value);
            } else {
                ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).slices[this.fieldIndex] = Varchars.isVarcharType((Type)type) ? Varchars.truncateToLength((Slice)Slices.wrappedBuffer(value.getBytes()), (Type)type) : (Chars.isCharType((Type)type) ? Chars.truncateToLengthAndTrimSpaces((Slice)Slices.wrappedBuffer(value.getBytes()), (Type)type) : Slices.wrappedBuffer(value.getBytes()));
            }
        }

        public void addFloat(float value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = Float.floatToRawIntBits(value);
        }

        public void addInt(int value) {
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).nulls[this.fieldIndex] = false;
            ((ParquetHiveRecordCursor)ParquetHiveRecordCursor.this).longs[this.fieldIndex] = value;
        }
    }

    public static class ParquetGroupConverter
    extends GroupConverter {
        private final List<Converter> converters;

        public ParquetGroupConverter(List<Converter> converters) {
            this.converters = converters;
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters.get(fieldIndex);
        }

        public void start() {
        }

        public void end() {
        }
    }

    private static enum FakeParquetRecord {
        MATERIALIZE_RECORD;

    }

    private static class ParquetRecordConverter
    extends RecordMaterializer<FakeParquetRecord> {
        private final ParquetGroupConverter groupConverter;

        public ParquetRecordConverter(List<Converter> converters) {
            this.groupConverter = new ParquetGroupConverter(converters);
        }

        public FakeParquetRecord getCurrentRecord() {
            return FakeParquetRecord.MATERIALIZE_RECORD;
        }

        public GroupConverter getRootConverter() {
            return this.groupConverter;
        }
    }

    public final class PrestoReadSupport
    extends ReadSupport<FakeParquetRecord> {
        private final boolean useParquetColumnNames;
        private final List<HiveColumnHandle> columns;
        private final List<Converter> converters;

        public PrestoReadSupport(boolean useParquetColumnNames, List<HiveColumnHandle> columns, MessageType messageType) {
            this.columns = columns;
            this.useParquetColumnNames = useParquetColumnNames;
            ImmutableList.Builder converters = ImmutableList.builder();
            for (int i = 0; i < columns.size(); ++i) {
                parquet.schema.Type parquetType;
                HiveColumnHandle column = columns.get(i);
                if (column.getColumnType() != HiveColumnHandle.ColumnType.REGULAR || (parquetType = ParquetTypeUtils.getParquetType(column, messageType, useParquetColumnNames)) == null) continue;
                if (parquetType.isPrimitive()) {
                    Optional<DecimalType> decimalType = HiveUtil.getDecimalType(column.getHiveType());
                    if (decimalType.isPresent()) {
                        converters.add((Object)new ParquetDecimalColumnConverter(i, decimalType.get()));
                        continue;
                    }
                    converters.add((Object)new ParquetPrimitiveColumnConverter(i));
                    continue;
                }
                converters.add((Object)new ParquetColumnConverter(ParquetHiveRecordCursor.createGroupConverter(ParquetHiveRecordCursor.this.types[i], parquetType.getName(), parquetType, i), i));
            }
            this.converters = converters.build();
        }

        public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType messageType) {
            List fields = this.columns.stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetTypeUtils.getParquetType(column, messageType, this.useParquetColumnNames)).filter(Objects::nonNull).collect(Collectors.toList());
            MessageType requestedProjection = new MessageType(messageType.getName(), fields);
            return new ReadSupport.ReadContext(requestedProjection);
        }

        public RecordMaterializer<FakeParquetRecord> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
            return new ParquetRecordConverter(this.converters);
        }
    }

    public class PrestoParquetRecordReader
    extends ParquetRecordReader<FakeParquetRecord> {
        public PrestoParquetRecordReader(PrestoReadSupport readSupport) {
            super((ReadSupport)readSupport);
        }
    }
}

