/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication;

import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;

final class KerberosTicketUtils {
    private static final float TICKET_RENEW_WINDOW = 0.8f;

    private KerberosTicketUtils() {
    }

    static KerberosTicket getTicketGrantingTicket(Subject subject) {
        Set<KerberosTicket> tickets = subject.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket ticket : tickets) {
            if (!KerberosTicketUtils.isOriginalTicketGrantingTicket(ticket)) continue;
            return ticket;
        }
        throw new IllegalArgumentException("kerberos ticket not found in " + subject);
    }

    static long getRefreshTime(KerberosTicket ticket) {
        long start = ticket.getStartTime().getTime();
        long end = ticket.getEndTime().getTime();
        return start + (long)((float)(end - start) * 0.8f);
    }

    static boolean isOriginalTicketGrantingTicket(KerberosTicket ticket) {
        return KerberosTicketUtils.isTicketGrantingServerPrincipal(ticket.getServer());
    }

    private static boolean isTicketGrantingServerPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }
}

