/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveConnectorFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Plugin;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorFactory;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Strings;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;

public class HivePlugin
implements Plugin {
    private final String name;
    private ExtendedHiveMetastore metastore;

    public HivePlugin(String name) {
        this(name, null);
    }

    public HivePlugin(String name, ExtendedHiveMetastore metastore) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name is null or empty");
        this.name = name;
        this.metastore = metastore;
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of(new HiveConnectorFactory(this.name, HivePlugin.getClassLoader(), this.metastore));
    }

    private static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = HivePlugin.class.getClassLoader();
        }
        return classLoader;
    }
}

