/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.DeleteItemOutcome;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.Expected;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.Table;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.api.DeleteItemApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.spec.DeleteItemSpec;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;

public class DeleteItemImpl
extends AbstractImpl
implements DeleteItemApi {
    public DeleteItemImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public DeleteItemOutcome deleteItem(KeyAttribute ... primaryKeyComponents) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeyComponents));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKey));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKeys, Expected ... expected) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeys).withExpected(expected));
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKeys, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doDeleteItem(new DeleteItemSpec().withPrimaryKey(primaryKeys).withConditionExpression(conditionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public DeleteItemOutcome deleteItem(DeleteItemSpec spec) {
        return this.doDeleteItem(spec);
    }

    private DeleteItemOutcome doDeleteItem(DeleteItemSpec spec) {
        String tableName = this.getTable().getTableName();
        DeleteItemRequest req = ((DeleteItemRequest)spec.getRequest()).withTableName(tableName).withKey(InternalUtils.toAttributeValueMap(spec.getKeyComponents()));
        Collection<Expected> expected = spec.getExpected();
        Map<String, ExpectedAttributeValue> expectedMap = InternalUtils.toExpectedAttributeValueMap(expected);
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withExpected(expectedMap).withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        DeleteItemResult result = this.getClient().deleteItem(req);
        return new DeleteItemOutcome(result);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue));
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue));
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, Expected ... expected) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue), expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Expected ... expected) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue), conditionExpression, nameMap, valueMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItem(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue), conditionExpression, nameMap, valueMap);
    }
}

