/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import javax.inject.Singleton;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.CoercionPolicy;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.DirectoryLister;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.FileFormatDataSourceStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ForCachingHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ForHiveClient;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.GenericHiveRecordCursorProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HadoopDirectoryLister;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsConfigurationUpdater;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveCluster;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveCoercionPolicy;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveConnectorId;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveEventClient;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveFileWriterFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveHdfsConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveLocationService;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveMetadata;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveMetadataFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveMetastoreClientFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveNodePartitioningProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePageSinkProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePageSourceProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePartitionManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveRecordCursorProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSessionProperties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSplitManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveTableProperties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveTransactionHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveTransactionManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveTypeTranslator;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.LocationService;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.NamenodeStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.OrcFileWriterFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PartitionUpdate;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.RcFileFileWriterFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.S3ConfigurationUpdater;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.StaticHiveCluster;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.StaticMetastoreConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.TableParameterCodec;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.TypeTranslator;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.orc.DwrfPageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.orc.OrcPageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetPageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetRecordCursorProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.rcfile.RcFilePageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.HiveS3Config;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.PrestoS3ConfigurationUpdater;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.PrestoS3FileSystemStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.NodeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PageIndexerFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorSplitManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Provides;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Scopes;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.multibindings.Multibinder;
import org.apache.flink.fs.s3presto.shaded.io.airlift.concurrent.Threads;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigBinder;
import org.apache.flink.fs.s3presto.shaded.io.airlift.event.client.EventClient;
import org.apache.flink.fs.s3presto.shaded.io.airlift.json.JsonCodecBinder;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.ObjectNames;
import org.apache.flink.fs.s3presto.shaded.org.weakref.jmx.guice.ExportBinder;

public class HiveClientModule
implements Module {
    private final String connectorId;
    private final TypeManager typeManager;
    private final PageIndexerFactory pageIndexerFactory;
    private final NodeManager nodeManager;

    public HiveClientModule(String connectorId, TypeManager typeManager, PageIndexerFactory pageIndexerFactory, NodeManager nodeManager) {
        this.connectorId = connectorId;
        this.typeManager = typeManager;
        this.pageIndexerFactory = pageIndexerFactory;
        this.nodeManager = nodeManager;
    }

    public void configure(Binder binder) {
        binder.bind(HiveConnectorId.class).toInstance((Object)new HiveConnectorId(this.connectorId));
        binder.bind(TypeTranslator.class).toInstance((Object)new HiveTypeTranslator());
        binder.bind(CoercionPolicy.class).to(HiveCoercionPolicy.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfigurationUpdater.class).in(Scopes.SINGLETON);
        binder.bind(HdfsConfiguration.class).to(HiveHdfsConfiguration.class).in(Scopes.SINGLETON);
        binder.bind(HdfsEnvironment.class).in(Scopes.SINGLETON);
        binder.bind(DirectoryLister.class).to(HadoopDirectoryLister.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder(binder).bindConfig(HiveClientConfig.class);
        ConfigBinder.configBinder(binder).bindConfig(HiveS3Config.class);
        binder.bind(S3ConfigurationUpdater.class).to(PrestoS3ConfigurationUpdater.class).in(Scopes.SINGLETON);
        binder.bind(HiveSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(HiveTableProperties.class).in(Scopes.SINGLETON);
        binder.bind(NamenodeStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter(binder).export(NamenodeStats.class).as(ObjectNames.generatedNameOf(NamenodeStats.class, this.connectorId));
        binder.bind(HiveMetastoreClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(HiveCluster.class).to(StaticHiveCluster.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder(binder).bindConfig(StaticMetastoreConfig.class);
        binder.bind(NodeManager.class).toInstance((Object)this.nodeManager);
        binder.bind(TypeManager.class).toInstance((Object)this.typeManager);
        binder.bind(PageIndexerFactory.class).toInstance((Object)this.pageIndexerFactory);
        Multibinder recordCursorProviderBinder = Multibinder.newSetBinder((Binder)binder, HiveRecordCursorProvider.class);
        recordCursorProviderBinder.addBinding().to(ParquetRecordCursorProvider.class).in(Scopes.SINGLETON);
        recordCursorProviderBinder.addBinding().to(GenericHiveRecordCursorProvider.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, EventClient.class).addBinding().to(HiveEventClient.class).in(Scopes.SINGLETON);
        binder.bind(HivePartitionManager.class).in(Scopes.SINGLETON);
        binder.bind(LocationService.class).to(HiveLocationService.class).in(Scopes.SINGLETON);
        binder.bind(TableParameterCodec.class).in(Scopes.SINGLETON);
        binder.bind(HiveMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(HiveTransactionManager.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorSplitManager.class).to(HiveSplitManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter(binder).export(ConnectorSplitManager.class).as(ObjectNames.generatedNameOf(HiveSplitManager.class, this.connectorId));
        binder.bind(ConnectorPageSourceProvider.class).to(HivePageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorPageSinkProvider.class).to(HivePageSinkProvider.class).in(Scopes.SINGLETON);
        binder.bind(ConnectorNodePartitioningProvider.class).to(HiveNodePartitioningProvider.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(PartitionUpdate.class);
        binder.bind(FileFormatDataSourceStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter(binder).export(FileFormatDataSourceStats.class).as(ObjectNames.generatedNameOf(FileFormatDataSourceStats.class, this.connectorId));
        Multibinder pageSourceFactoryBinder = Multibinder.newSetBinder((Binder)binder, HivePageSourceFactory.class);
        pageSourceFactoryBinder.addBinding().to(OrcPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(DwrfPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(ParquetPageSourceFactory.class).in(Scopes.SINGLETON);
        pageSourceFactoryBinder.addBinding().to(RcFilePageSourceFactory.class).in(Scopes.SINGLETON);
        Multibinder fileWriterFactoryBinder = Multibinder.newSetBinder((Binder)binder, HiveFileWriterFactory.class);
        fileWriterFactoryBinder.addBinding().to(OrcFileWriterFactory.class).in(Scopes.SINGLETON);
        fileWriterFactoryBinder.addBinding().to(RcFileFileWriterFactory.class).in(Scopes.SINGLETON);
        binder.bind(PrestoS3FileSystemStats.class).toInstance((Object)PrestoS3FileSystem.getFileSystemStats());
        ExportBinder.newExporter(binder).export(PrestoS3FileSystemStats.class).as(ObjectNames.generatedNameOf(PrestoS3FileSystem.class, this.connectorId));
    }

    @ForHiveClient
    @Singleton
    @Provides
    public ExecutorService createHiveClientExecutor(HiveConnectorId hiveClientId) {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("hive-" + hiveClientId + "-%s")));
    }

    @ForCachingHiveMetastore
    @Singleton
    @Provides
    public ExecutorService createCachingHiveMetastoreExecutor(HiveConnectorId hiveClientId, HiveClientConfig hiveClientConfig) {
        return Executors.newFixedThreadPool(hiveClientConfig.getMaxMetastoreRefreshThreads(), Threads.daemonThreadsNamed((String)("hive-metastore-" + hiveClientId + "-%s")));
    }

    @Singleton
    @Provides
    public Function<HiveTransactionHandle, SemiTransactionalHiveMetastore> createMetastoreGetter(HiveTransactionManager transactionManager) {
        return transactionHandle -> ((HiveMetadata)transactionManager.get((ConnectorTransactionHandle)transactionHandle)).getMetastore();
    }
}

