/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.files;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.ValidationFailure;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.files.PersistentCommitData;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PendingSet
extends PersistentCommitData {
    private static final Logger LOG = LoggerFactory.getLogger(PendingSet.class);
    public static final int VERSION = 1;
    private static final long serialVersionUID = 69633L;
    private int version = 1;
    private List<SinglePendingCommit> commits;
    private final Map<String, String> extraData = new HashMap<String, String>(0);

    public PendingSet() {
        this(0);
    }

    public PendingSet(int size) {
        this.commits = new ArrayList<SinglePendingCommit>(size);
    }

    public static JsonSerialization<PendingSet> serializer() {
        return new JsonSerialization<PendingSet>(PendingSet.class, false, true);
    }

    public static PendingSet load(FileSystem fs, Path path) throws IOException {
        LOG.debug("Reading pending commits in file {}", (Object)path);
        PendingSet instance = PendingSet.serializer().load(fs, path);
        instance.validate();
        return instance;
    }

    public void add(SinglePendingCommit commit) {
        this.commits.add(commit);
    }

    private void readObject(ObjectInputStream inStream) throws IOException, ClassNotFoundException {
        inStream.defaultReadObject();
        this.validate();
    }

    @Override
    public void validate() throws ValidationFailure {
        ValidationFailure.verify(this.version == 1, "Wrong version: %s", this.version);
        CommitUtils.validateCollectionClass(this.extraData.keySet(), String.class);
        CommitUtils.validateCollectionClass(this.extraData.values(), String.class);
        HashSet<String> destinations = new HashSet<String>(this.commits.size());
        CommitUtils.validateCollectionClass(this.commits, SinglePendingCommit.class);
        for (SinglePendingCommit c : this.commits) {
            c.validate();
            ValidationFailure.verify(!destinations.contains(c.getDestinationKey()), "Destination %s is written to by more than one pending commit", c.getDestinationKey());
            destinations.add(c.getDestinationKey());
        }
    }

    @Override
    public byte[] toBytes() throws IOException {
        return PendingSet.serializer().toBytes(this);
    }

    public int size() {
        return this.commits != null ? this.commits.size() : 0;
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        PendingSet.serializer().save(fs, path, this, overwrite);
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<SinglePendingCommit> getCommits() {
        return this.commits;
    }

    public void setCommits(List<SinglePendingCommit> commits) {
        this.commits = commits;
    }
}

