/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.orc;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.hive.orc.OrcSerde;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.FileFormatDataSourceStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveSessionProperties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.orc.OrcPageSourceFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.orc.metadata.DwrfMetadataReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.orc.metadata.MetadataReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorPageSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.TupleDomain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.org.joda.time.DateTimeZone;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;

public class DwrfPageSourceFactory
implements HivePageSourceFactory {
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;

    @Inject
    public DwrfPageSourceFactory(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone) {
        if (!HiveUtil.isDeserializerClass(schema, OrcSerde.class)) {
            return Optional.empty();
        }
        return Optional.of(OrcPageSourceFactory.createOrcPageSource((MetadataReader)new DwrfMetadataReader(), this.hdfsEnvironment, session.getUser(), configuration, path, start, length, fileSize, columns, false, effectivePredicate, hiveStorageTimeZone, this.typeManager, HiveSessionProperties.getOrcMaxMergeDistance(session), HiveSessionProperties.getOrcMaxBufferSize(session), HiveSessionProperties.getOrcStreamBufferSize(session), HiveSessionProperties.getOrcMaxReadBlockSize(session), HiveSessionProperties.getOrcLazyReadSmallRanges(session), false, this.stats));
    }
}

