/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.thrift.TException;

@Immutable
public class HivePrincipal {
    private static final String PUBLIC_ROLE_NAME = "public";
    private final String principalName;
    private final PrincipalType principalType;

    public HivePrincipal(String principalName, PrincipalType principalType) {
        this.principalType = principalType;
        this.principalName = principalType == PrincipalType.ROLE ? principalName.toLowerCase(Locale.US) : principalName;
    }

    public static HivePrincipal toHivePrincipal(String grantee) throws TException {
        if (grantee.equalsIgnoreCase(PUBLIC_ROLE_NAME)) {
            return new HivePrincipal(PUBLIC_ROLE_NAME, PrincipalType.ROLE);
        }
        return new HivePrincipal(grantee, PrincipalType.USER);
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public int hashCode() {
        return Objects.hash(this.principalName, this.principalType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrincipal hivePrincipal = (HivePrincipal)o;
        return Objects.equals(this.principalName, hivePrincipal.principalName) && Objects.equals(this.principalType, hivePrincipal.principalType);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("principalName", this.principalName).add("principalType", this.principalType).toString();
    }
}

