/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Properties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HivePartitionKey;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveTypeName;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.HostAddress;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.SizeOf;
import org.apache.flink.fs.s3presto.shaded.org.openjdk.jol.info.ClassLayout;

public class InternalHiveSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(InternalHiveSplit.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize() + ClassLayout.parseClass(Properties.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize() + ClassLayout.parseClass(OptionalInt.class).instanceSize();
    private static final int HOST_ADDRESS_INSTANCE_SIZE = ClassLayout.parseClass(HostAddress.class).instanceSize() + ClassLayout.parseClass(String.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String partitionName;
    private final OptionalInt bucketNumber;
    private final boolean forceLocalScheduling;
    private final Map<Integer, HiveTypeName> columnCoercions;

    public InternalHiveSplit(String partitionName, String path, long start, long length, long fileSize, Properties schema, List<HivePartitionKey> partitionKeys, List<HostAddress> addresses, OptionalInt bucketNumber, boolean forceLocalScheduling, Map<Integer, HiveTypeName> columnCoercions) {
        Preconditions.checkArgument(start >= 0L, "start must be positive");
        Preconditions.checkArgument(length >= 0L, "length must be positive");
        Preconditions.checkArgument(fileSize >= 0L, "fileSize must be positive");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        Objects.requireNonNull(columnCoercions, "columnCoercions is null");
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
        this.bucketNumber = bucketNumber;
        this.forceLocalScheduling = forceLocalScheduling;
        this.columnCoercions = ImmutableMap.copyOf(columnCoercions);
    }

    public String getPath() {
        return this.path;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Properties getSchema() {
        return this.schema;
    }

    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    public Map<Integer, HiveTypeName> getColumnCoercions() {
        return this.columnCoercions;
    }

    public int getEstimatedSizeInBytes() {
        int result = INSTANCE_SIZE;
        result += this.path.length() * 2;
        result = (int)((long)result + SizeOf.sizeOfObjectArray(this.partitionKeys.size()));
        for (HivePartitionKey partitionKey : this.partitionKeys) {
            result += partitionKey.getEstimatedSizeInBytes();
        }
        result = (int)((long)result + SizeOf.sizeOfObjectArray(this.addresses.size()));
        for (HostAddress address : this.addresses) {
            result += HOST_ADDRESS_INSTANCE_SIZE + address.getHostText().length() * 2;
        }
        result += this.partitionName.length() * 2;
        result = (int)((long)result + SizeOf.sizeOfObjectArray(this.columnCoercions.size()));
        for (HiveTypeName hiveTypeName : this.columnCoercions.values()) {
            result += INTEGER_INSTANCE_SIZE + hiveTypeName.getEstimatedSizeInBytes();
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.path).addValue(this.start).addValue(this.length).addValue(this.fileSize).toString();
    }
}

