/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.TypeTranslator;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.StandardErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.BigintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.BooleanType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.CharType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DateType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DecimalType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DoubleType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.IntegerType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.NamedTypeSignature;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.RealType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.SmallintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TimestampType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TinyintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeSignatureParameter;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.VarbinaryType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.VarcharType;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class HiveTypeTranslator
implements TypeTranslator {
    @Override
    public TypeInfo translate(Type type) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return HiveType.HIVE_BOOLEAN.getTypeInfo();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return HiveType.HIVE_LONG.getTypeInfo();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return HiveType.HIVE_INT.getTypeInfo();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return HiveType.HIVE_SHORT.getTypeInfo();
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return HiveType.HIVE_BYTE.getTypeInfo();
        }
        if (RealType.REAL.equals((Object)type)) {
            return HiveType.HIVE_FLOAT.getTypeInfo();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return HiveType.HIVE_DOUBLE.getTypeInfo();
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            int varcharLength = varcharType.getLength();
            if (varcharLength <= 65535) {
                return TypeInfoFactory.getVarcharTypeInfo((int)varcharLength);
            }
            if (varcharLength == Integer.MAX_VALUE) {
                return HiveType.HIVE_STRING.getTypeInfo();
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported VARCHAR types: VARCHAR(<=%d), VARCHAR.", type, 65535));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            int charLength = charType.getLength();
            if (charLength <= 255) {
                return TypeInfoFactory.getCharTypeInfo((int)charLength);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s. Supported CHAR types: CHAR(<=%d).", type, 255));
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return HiveType.HIVE_BINARY.getTypeInfo();
        }
        if (DateType.DATE.equals((Object)type)) {
            return HiveType.HIVE_DATE.getTypeInfo();
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return HiveType.HIVE_TIMESTAMP.getTypeInfo();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale());
        }
        if (HiveUtil.isArrayType(type)) {
            TypeInfo elementType = this.translate((Type)type.getTypeParameters().get(0));
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementType);
        }
        if (HiveUtil.isMapType(type)) {
            TypeInfo keyType = this.translate((Type)type.getTypeParameters().get(0));
            TypeInfo valueType = this.translate((Type)type.getTypeParameters().get(1));
            return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyType, (TypeInfo)valueType);
        }
        if (HiveUtil.isRowType(type)) {
            ImmutableList.Builder fieldNames = ImmutableList.builder();
            for (TypeSignatureParameter parameter : type.getTypeSignature().getParameters()) {
                if (!parameter.isNamedTypeSignature()) {
                    throw new IllegalArgumentException(String.format("Expected all parameters to be named type, but got %s", parameter));
                }
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                fieldNames.add(namedTypeSignature.getName());
            }
            return TypeInfoFactory.getStructTypeInfo((List)((Object)fieldNames.build()), type.getTypeParameters().stream().map(this::translate).collect(Collectors.toList()));
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type: %s", type));
    }
}

