/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsConfigurationUpdater;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.ConfigurationUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;

public class HiveHdfsConfiguration
implements HdfsConfiguration {
    private static final Configuration INITIAL_CONFIGURATION;
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration configuration = new Configuration(false);
            ConfigurationUtils.copy(INITIAL_CONFIGURATION, configuration);
            HiveHdfsConfiguration.this.updater.updateConfiguration(configuration);
            return configuration;
        }
    };
    private final HdfsConfigurationUpdater updater;

    @Inject
    public HiveHdfsConfiguration(HdfsConfigurationUpdater updater) {
        this.updater = Objects.requireNonNull(updater, "updater is null");
    }

    @Override
    public Configuration getConfiguration(HdfsEnvironment.HdfsContext context, URI uri) {
        return this.hadoopConfiguration.get();
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        INITIAL_CONFIGURATION = new Configuration(false);
        Configuration defaultConfiguration = new Configuration();
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

