/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.AmazonS3;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.AmazonS3Client;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.DeleteObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.DeleteObjectsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.DeleteObjectsResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.GetObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsV2Result;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.MultipartUploadListing;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ObjectListing;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PutObjectResult;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.S3Object;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.S3ObjectSummary;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import org.apache.flink.fs.s3base.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.FailureInjectionPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.InconsistentS3Object;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InconsistentAmazonS3Client
extends AmazonS3Client {
    private static final Logger LOG = LoggerFactory.getLogger(InconsistentAmazonS3Client.class);
    private FailureInjectionPolicy policy;
    private final AtomicLong failureCounter = new AtomicLong(0L);
    private Map<String, Delete> delayedDeletes = new HashMap<String, Delete>();
    private Map<String, Long> delayedPutKeys = new HashMap<String, Long>();

    public InconsistentAmazonS3Client(AWSCredentialsProvider credentials, ClientConfiguration clientConfiguration, Configuration conf) {
        super(credentials, clientConfiguration);
        this.policy = new FailureInjectionPolicy(conf);
    }

    public static void clearInconsistency(S3AFileSystem fs) throws Exception {
        AmazonS3 s3 = fs.getAmazonS3ClientForTesting("s3guard");
        InconsistentAmazonS3Client ic = InconsistentAmazonS3Client.castFrom(s3);
        ic.clearInconsistency();
    }

    public static void setFailureInjectionPolicy(S3AFileSystem fs, FailureInjectionPolicy policy) throws Exception {
        AmazonS3 s3 = fs.getAmazonS3ClientForTesting("s3guard");
        InconsistentAmazonS3Client ic = InconsistentAmazonS3Client.castFrom(s3);
        ic.replacePolicy(policy);
    }

    private void replacePolicy(FailureInjectionPolicy pol) {
        this.policy = pol;
    }

    public String toString() {
        return String.format("Inconsistent S3 Client: %s; failure count %d", this.policy, this.failureCounter.get());
    }

    public void clearInconsistency() {
        LOG.info("clearing all delayed puts / deletes");
        this.delayedDeletes.clear();
        this.delayedPutKeys.clear();
    }

    public static InconsistentAmazonS3Client castFrom(AmazonS3 c) throws Exception {
        InconsistentAmazonS3Client ic = null;
        if (c instanceof InconsistentAmazonS3Client) {
            ic = (InconsistentAmazonS3Client)c;
        }
        Preconditions.checkNotNull(ic, "Not an instance of InconsistentAmazonS3Client");
        return ic;
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) throws AmazonClientException, AmazonServiceException {
        this.maybeFail();
        for (DeleteObjectsRequest.KeyVersion keyVersion : deleteObjectsRequest.getKeys()) {
            this.registerDeleteObject(keyVersion.getKey(), deleteObjectsRequest.getBucketName());
        }
        return super.deleteObjects(deleteObjectsRequest);
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws AmazonClientException, AmazonServiceException {
        String key = deleteObjectRequest.getKey();
        LOG.debug("key {}", (Object)key);
        this.maybeFail();
        this.registerDeleteObject(key, deleteObjectRequest.getBucketName());
        super.deleteObject(deleteObjectRequest);
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("key {}", (Object)putObjectRequest.getKey());
        this.maybeFail();
        this.registerPutObject(putObjectRequest);
        return super.putObject(putObjectRequest);
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        this.maybeFail();
        return this.innerlistObjects(listObjectsRequest);
    }

    private ObjectListing innerlistObjects(ListObjectsRequest listObjectsRequest) throws AmazonClientException, AmazonServiceException {
        LOG.debug("prefix {}", (Object)listObjectsRequest.getPrefix());
        ObjectListing listing = super.listObjects(listObjectsRequest);
        listing = this.filterListObjects(listing);
        listing = this.restoreListObjects(listObjectsRequest, listing);
        return listing;
    }

    @Override
    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request request) throws AmazonClientException, AmazonServiceException {
        this.maybeFail();
        return this.innerListObjectsV2(request);
    }

    private ListObjectsV2Result innerListObjectsV2(ListObjectsV2Request request) {
        LOG.debug("prefix {}", (Object)request.getPrefix());
        ListObjectsV2Result listing = super.listObjectsV2(request);
        listing = this.filterListObjectsV2(listing);
        listing = this.restoreListObjectsV2(request, listing);
        return listing;
    }

    private void addSummaryIfNotPresent(List<S3ObjectSummary> list, S3ObjectSummary item) {
        String key = item.getKey();
        if (list.stream().noneMatch(member -> member.getKey().equals(key))) {
            list.add(item);
        }
    }

    private void addPrefixIfNotPresent(List<String> prefixes, String ancestor, String child) {
        Path prefixCandidate = new Path(child).getParent();
        Path ancestorPath = new Path(ancestor);
        Preconditions.checkArgument(child.startsWith(ancestor), "%s does not start with %s", child, ancestor);
        while (!prefixCandidate.isRoot()) {
            Path nextParent = prefixCandidate.getParent();
            if (nextParent.equals(ancestorPath)) {
                String prefix = prefixCandidate.toString();
                if (!prefixes.contains(prefix)) {
                    prefixes.add(prefix);
                }
                return;
            }
            prefixCandidate = nextParent;
        }
    }

    private boolean isDescendant(String parent, String child, boolean recursive) {
        if (recursive) {
            if (!parent.endsWith("/")) {
                parent = parent + "/";
            }
            return child.startsWith(parent);
        }
        Path actualParentPath = new Path(child).getParent();
        Path expectedParentPath = new Path(parent);
        return actualParentPath.equals(expectedParentPath);
    }

    private ObjectListing restoreListObjects(ListObjectsRequest request, ObjectListing rawListing) {
        List<S3ObjectSummary> outputList = rawListing.getObjectSummaries();
        List<String> outputPrefixes = rawListing.getCommonPrefixes();
        boolean recursiveObjectList = !"/".equals(request.getDelimiter());
        String prefix = request.getPrefix();
        this.restoreDeleted(outputList, outputPrefixes, recursiveObjectList, prefix);
        return new CustomObjectListing(rawListing, outputList, outputPrefixes);
    }

    private ListObjectsV2Result restoreListObjectsV2(ListObjectsV2Request request, ListObjectsV2Result result) {
        List<S3ObjectSummary> outputList = result.getObjectSummaries();
        List<String> outputPrefixes = result.getCommonPrefixes();
        boolean recursiveObjectList = !"/".equals(request.getDelimiter());
        String prefix = request.getPrefix();
        this.restoreDeleted(outputList, outputPrefixes, recursiveObjectList, prefix);
        return new CustomListObjectsV2Result(result, outputList, outputPrefixes);
    }

    private void restoreDeleted(List<S3ObjectSummary> summaries, List<String> prefixes, boolean recursive, String prefix) {
        for (String key : new HashSet<String>(this.delayedDeletes.keySet())) {
            Delete delete = this.delayedDeletes.get(key);
            if (this.isKeyDelayed(delete.time(), key)) {
                if (this.isDescendant(prefix, key, recursive) && delete.summary() != null) {
                    this.addSummaryIfNotPresent(summaries, delete.summary());
                }
                if (recursive || !this.isDescendant(prefix, key, true)) continue;
                this.addPrefixIfNotPresent(prefixes, prefix, key);
                continue;
            }
            this.delayedDeletes.remove(key);
        }
    }

    private ObjectListing filterListObjects(ObjectListing rawListing) {
        List<S3ObjectSummary> outputList = this.filterSummaries(rawListing.getObjectSummaries());
        List<String> outputPrefixes = this.filterPrefixes(rawListing.getCommonPrefixes());
        return new CustomObjectListing(rawListing, outputList, outputPrefixes);
    }

    private ListObjectsV2Result filterListObjectsV2(ListObjectsV2Result raw) {
        List<S3ObjectSummary> outputList = this.filterSummaries(raw.getObjectSummaries());
        List<String> outputPrefixes = this.filterPrefixes(raw.getCommonPrefixes());
        return new CustomListObjectsV2Result(raw, outputList, outputPrefixes);
    }

    private List<S3ObjectSummary> filterSummaries(List<S3ObjectSummary> summaries) {
        ArrayList<S3ObjectSummary> outputList = new ArrayList<S3ObjectSummary>();
        for (S3ObjectSummary s : summaries) {
            String key = s.getKey();
            if (this.isKeyDelayed(this.delayedPutKeys.get(key), key)) continue;
            outputList.add(s);
        }
        return outputList;
    }

    private List<String> filterPrefixes(List<String> prefixes) {
        return prefixes.stream().filter(key -> !this.isKeyDelayed(this.delayedPutKeys.get(key), (String)key)).collect(Collectors.toList());
    }

    private boolean isKeyDelayed(Long enqueueTime, String key) {
        long deadline;
        if (enqueueTime == null) {
            LOG.debug("no delay for key {}", (Object)key);
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= (deadline = enqueueTime + this.policy.getDelayKeyMsec())) {
            this.delayedDeletes.remove(key);
            LOG.debug("no longer delaying {}", (Object)key);
            return false;
        }
        LOG.info("delaying {}", (Object)key);
        return true;
    }

    private void registerDeleteObject(String key, String bucket) {
        if (this.policy.shouldDelay(key)) {
            ListObjectsRequest request = new ListObjectsRequest().withBucketName(bucket).withPrefix(key);
            S3ObjectSummary summary = this.innerlistObjects(request).getObjectSummaries().stream().filter(result -> result.getKey().equals(key)).findFirst().orElse(null);
            this.delayedDeletes.put(key, new Delete(System.currentTimeMillis(), summary));
        }
    }

    private void registerPutObject(PutObjectRequest req) {
        String key = req.getKey();
        if (this.policy.shouldDelay(key)) {
            this.enqueueDelayedPut(key);
        }
    }

    private void enqueueDelayedPut(String key) {
        LOG.debug("delaying put of {}", (Object)key);
        this.delayedPutKeys.put(key, System.currentTimeMillis());
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.completeMultipartUpload(completeMultipartUploadRequest);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.uploadPart(uploadPartRequest);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.initiateMultipartUpload(initiateMultipartUploadRequest);
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws SdkClientException, AmazonServiceException {
        this.maybeFail();
        return super.listMultipartUploads(listMultipartUploadsRequest);
    }

    public long getDelayKeyMsec() {
        return this.policy.getDelayKeyMsec();
    }

    public void setThrottleProbability(float throttleProbability) {
        this.policy.setThrottleProbability(throttleProbability);
    }

    private void maybeFail(String errorMsg, int statusCode) throws AmazonClientException {
        AmazonServiceException ex = null;
        if (FailureInjectionPolicy.trueWithProbability(this.policy.getThrottleProbability())) {
            ex = new AmazonServiceException(errorMsg + " count = " + (this.failureCounter.get() + 1L), null);
            ex.setStatusCode(statusCode);
        }
        int failureLimit = this.policy.getFailureLimit();
        if (ex != null) {
            long count = this.failureCounter.incrementAndGet();
            if (failureLimit == 0 || failureLimit > 0 && count < (long)failureLimit) {
                throw ex;
            }
        }
    }

    private void maybeFail() {
        this.maybeFail("throttled", 503);
    }

    public void setFailureLimit(int limit) {
        this.policy.setFailureLimit(limit);
        this.failureCounter.set(0L);
    }

    @Override
    public S3Object getObject(GetObjectRequest var1) throws SdkClientException, AmazonServiceException {
        this.maybeFail("file not found", 404);
        S3Object o = super.getObject(var1);
        LOG.debug("Wrapping in InconsistentS3Object for key {}", (Object)var1.getKey());
        return new InconsistentS3Object(o, this.policy);
    }

    @Override
    public S3Object getObject(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        S3Object o = super.getObject(bucketName, key);
        LOG.debug("Wrapping in InconsistentS3Object for key {}", (Object)key);
        return new InconsistentS3Object(o, this.policy);
    }

    private static class CustomListObjectsV2Result
    extends ListObjectsV2Result {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        CustomListObjectsV2Result(ListObjectsV2Result raw, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(raw.getBucketName());
            this.setCommonPrefixes(raw.getCommonPrefixes());
            this.setDelimiter(raw.getDelimiter());
            this.setEncodingType(raw.getEncodingType());
            this.setStartAfter(raw.getStartAfter());
            this.setMaxKeys(raw.getMaxKeys());
            this.setContinuationToken(raw.getContinuationToken());
            this.setPrefix(raw.getPrefix());
            this.setTruncated(raw.isTruncated());
        }

        @Override
        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        @Override
        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }

    private static class CustomObjectListing
    extends ObjectListing {
        private final List<S3ObjectSummary> customListing;
        private final List<String> customPrefixes;

        CustomObjectListing(ObjectListing rawListing, List<S3ObjectSummary> customListing, List<String> customPrefixes) {
            this.customListing = customListing;
            this.customPrefixes = customPrefixes;
            this.setBucketName(rawListing.getBucketName());
            this.setCommonPrefixes(rawListing.getCommonPrefixes());
            this.setDelimiter(rawListing.getDelimiter());
            this.setEncodingType(rawListing.getEncodingType());
            this.setMarker(rawListing.getMarker());
            this.setMaxKeys(rawListing.getMaxKeys());
            this.setNextMarker(rawListing.getNextMarker());
            this.setPrefix(rawListing.getPrefix());
            this.setTruncated(rawListing.isTruncated());
        }

        @Override
        public List<S3ObjectSummary> getObjectSummaries() {
            return this.customListing;
        }

        @Override
        public List<String> getCommonPrefixes() {
            return this.customPrefixes;
        }
    }

    private static class Delete {
        private Long time;
        private S3ObjectSummary summary;

        Delete(Long time, S3ObjectSummary summary) {
            this.time = time;
            this.summary = summary;
        }

        public Long time() {
            return this.time;
        }

        public S3ObjectSummary summary() {
            return this.summary;
        }
    }
}

