/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3;

import java.io.File;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.S3ConfigurationUpdater;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.HiveS3Config;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.PrestoS3SignerType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.s3.PrestoS3SseType;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.DataSize;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.Duration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;

public class PrestoS3ConfigurationUpdater
implements S3ConfigurationUpdater {
    private final String awsAccessKey;
    private final String awsSecretKey;
    private final String endpoint;
    private final PrestoS3SignerType signerType;
    private final boolean pathStyleAccess;
    private final boolean useInstanceCredentials;
    private final boolean sslEnabled;
    private final boolean sseEnabled;
    private final PrestoS3SseType sseType;
    private final String encryptionMaterialsProvider;
    private final String kmsKeyId;
    private final String sseKmsKeyId;
    private final int maxClientRetries;
    private final int maxErrorRetries;
    private final Duration maxBackoffTime;
    private final Duration maxRetryTime;
    private final Duration connectTimeout;
    private final Duration socketTimeout;
    private final int maxConnections;
    private final DataSize multipartMinFileSize;
    private final DataSize multipartMinPartSize;
    private final File stagingDirectory;
    private final boolean pinClientToCurrentRegion;
    private final String userAgentPrefix;

    @Inject
    public PrestoS3ConfigurationUpdater(HiveS3Config config) {
        this.awsAccessKey = config.getS3AwsAccessKey();
        this.awsSecretKey = config.getS3AwsSecretKey();
        this.endpoint = config.getS3Endpoint();
        this.signerType = config.getS3SignerType();
        this.pathStyleAccess = config.isS3PathStyleAccess();
        this.useInstanceCredentials = config.isS3UseInstanceCredentials();
        this.sslEnabled = config.isS3SslEnabled();
        this.sseEnabled = config.isS3SseEnabled();
        this.sseType = config.getS3SseType();
        this.encryptionMaterialsProvider = config.getS3EncryptionMaterialsProvider();
        this.kmsKeyId = config.getS3KmsKeyId();
        this.sseKmsKeyId = config.getS3SseKmsKeyId();
        this.maxClientRetries = config.getS3MaxClientRetries();
        this.maxErrorRetries = config.getS3MaxErrorRetries();
        this.maxBackoffTime = config.getS3MaxBackoffTime();
        this.maxRetryTime = config.getS3MaxRetryTime();
        this.connectTimeout = config.getS3ConnectTimeout();
        this.socketTimeout = config.getS3SocketTimeout();
        this.maxConnections = config.getS3MaxConnections();
        this.multipartMinFileSize = config.getS3MultipartMinFileSize();
        this.multipartMinPartSize = config.getS3MultipartMinPartSize();
        this.stagingDirectory = config.getS3StagingDirectory();
        this.pinClientToCurrentRegion = config.isPinS3ClientToCurrentRegion();
        this.userAgentPrefix = config.getS3UserAgentPrefix();
    }

    @Override
    public void updateConfiguration(Configuration config) {
        config.set("fs.s3.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3a.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3n.impl", PrestoS3FileSystem.class.getName());
        if (this.awsAccessKey != null) {
            config.set("presto.s3.access-key", this.awsAccessKey);
        }
        if (this.awsSecretKey != null) {
            config.set("presto.s3.secret-key", this.awsSecretKey);
        }
        if (this.endpoint != null) {
            config.set("presto.s3.endpoint", this.endpoint);
        }
        if (this.signerType != null) {
            config.set("presto.s3.signer-type", this.signerType.name());
        }
        config.setBoolean("presto.s3.path-style-access", this.pathStyleAccess);
        config.setBoolean("presto.s3.use-instance-credentials", this.useInstanceCredentials);
        config.setBoolean("presto.s3.ssl.enabled", this.sslEnabled);
        config.setBoolean("presto.s3.sse.enabled", this.sseEnabled);
        config.set("presto.s3.sse.type", this.sseType.name());
        if (this.encryptionMaterialsProvider != null) {
            config.set("presto.s3.encryption-materials-provider", this.encryptionMaterialsProvider);
        }
        if (this.kmsKeyId != null) {
            config.set("presto.s3.kms-key-id", this.kmsKeyId);
        }
        if (this.sseKmsKeyId != null) {
            config.set("presto.s3.sse.kms-key-id", this.sseKmsKeyId);
        }
        config.setInt("presto.s3.max-client-retries", this.maxClientRetries);
        config.setInt("presto.s3.max-error-retries", this.maxErrorRetries);
        config.set("presto.s3.max-backoff-time", this.maxBackoffTime.toString());
        config.set("presto.s3.max-retry-time", this.maxRetryTime.toString());
        config.set("presto.s3.connect-timeout", this.connectTimeout.toString());
        config.set("presto.s3.socket-timeout", this.socketTimeout.toString());
        config.set("presto.s3.staging-directory", this.stagingDirectory.toString());
        config.setInt("presto.s3.max-connections", this.maxConnections);
        config.setLong("presto.s3.multipart.min-file-size", this.multipartMinFileSize.toBytes());
        config.setLong("presto.s3.multipart.min-part-size", this.multipartMinPartSize.toBytes());
        config.setBoolean("presto.s3.pin-client-to-current-region", this.pinClientToCurrentRegion);
        config.set("presto.s3.user-agent-prefix", this.userAgentPrefix);
    }
}

