/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTypeUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.RichColumnDescriptor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.memory.AggregatedMemoryContext;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorPageSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.Page;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.LazyBlock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.LazyBlockLoader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.RunLengthEncodedBlock;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.TupleDomain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import parquet.column.ColumnDescriptor;
import parquet.schema.MessageType;

public class ParquetPageSource
implements ConnectorPageSource {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private final ParquetReader parquetReader;
    private final ParquetDataSource dataSource;
    private final MessageType fileSchema;
    private final MessageType requestedSchema;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int batchId;
    private boolean closed;
    private long readTimeNanos;
    private final boolean useParquetColumnNames;
    private final AggregatedMemoryContext systemMemoryContext;

    public ParquetPageSource(ParquetReader parquetReader, ParquetDataSource dataSource, MessageType fileSchema, MessageType requestedSchema, Properties splitSchema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, boolean useParquetColumnNames, AggregatedMemoryContext systemMemoryContext) {
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.fileSchema = Objects.requireNonNull(fileSchema, "fileSchema is null");
        this.requestedSchema = Objects.requireNonNull(requestedSchema, "requestedSchema is null");
        this.useParquetColumnNames = useParquetColumnNames;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            Preconditions.checkState(column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR, "column type must be regular");
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add(name);
            typesBuilder.add(type);
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (ParquetTypeUtils.getParquetType(column, fileSchema, useParquetColumnNames) != null) continue;
            this.constantBlocks[columnIndex] = RunLengthEncodedBlock.create((Type)type, null, (int)1024);
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
    }

    public long getCompletedBytes() {
        return this.dataSource.getReadBytes();
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    public Page getNextPage() {
        try {
            ++this.batchId;
            long start = System.nanoTime();
            int batchSize = this.parquetReader.nextBatch();
            this.readTimeNanos += System.nanoTime() - start;
            if (this.closed || batchSize <= 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                Optional<RichColumnDescriptor> descriptor;
                if (this.constantBlocks[fieldId] != null) {
                    blocks[fieldId] = this.constantBlocks[fieldId].getRegion(0, batchSize);
                    continue;
                }
                Type type = this.types.get(fieldId);
                int fieldIndex = this.useParquetColumnNames ? ParquetTypeUtils.getFieldIndex(this.fileSchema, this.columnNames.get(fieldId)) : this.hiveColumnIndexes[fieldId];
                if (fieldIndex == -1) {
                    blocks[fieldId] = RunLengthEncodedBlock.create((Type)type, null, (int)batchSize);
                    continue;
                }
                String fieldName = ((parquet.schema.Type)this.fileSchema.getFields().get(fieldIndex)).getName();
                ArrayList<String> path = new ArrayList<String>();
                path.add(fieldName);
                blocks[fieldId] = "row".equals(type.getTypeSignature().getBase()) ? this.parquetReader.readStruct(type, path) : ("map".equals(type.getTypeSignature().getBase()) ? this.parquetReader.readMap(type, path) : ("array".equals(type.getTypeSignature().getBase()) ? this.parquetReader.readArray(type, path) : ((descriptor = ParquetTypeUtils.getDescriptor(this.fileSchema, this.requestedSchema, path)).isPresent() ? new LazyBlock(batchSize, (LazyBlockLoader)new ParquetBlockLoader(descriptor.get(), type)) : RunLengthEncodedBlock.create((Type)type, null, (int)batchSize))));
            }
            return new Page(batchSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final ColumnDescriptor columnDescriptor;
        private final Type type;
        private boolean loaded;

        public ParquetBlockLoader(ColumnDescriptor columnDescriptor, Type type) {
            this.expectedBatchId = ParquetPageSource.this.batchId;
            this.columnDescriptor = columnDescriptor;
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState(ParquetPageSource.this.batchId == this.expectedBatchId);
            try {
                Block block = ParquetPageSource.this.parquetReader.readPrimitive(this.columnDescriptor, this.type);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

