/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveBucketing;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.SchemaTableName;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.NullableValue;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;

public class HivePartition {
    public static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    private final SchemaTableName tableName;
    private final String partitionId;
    private final Map<ColumnHandle, NullableValue> keys;
    private final List<HiveBucketing.HiveBucket> buckets;

    public HivePartition(SchemaTableName tableName, List<HiveBucketing.HiveBucket> buckets) {
        this(tableName, UNPARTITIONED_ID, ImmutableMap.of(), buckets);
    }

    public HivePartition(SchemaTableName tableName, String partitionId, Map<ColumnHandle, NullableValue> keys, List<HiveBucketing.HiveBucket> buckets) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partitionId = Objects.requireNonNull(partitionId, "partitionId is null");
        this.keys = ImmutableMap.copyOf(Objects.requireNonNull(keys, "keys is null"));
        this.buckets = Objects.requireNonNull(buckets, "bucket number is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public Map<ColumnHandle, NullableValue> getKeys() {
        return this.keys;
    }

    public List<HiveBucketing.HiveBucket> getBuckets() {
        return this.buckets;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartition other = (HivePartition)obj;
        return Objects.equals(this.partitionId, other.partitionId);
    }

    public String toString() {
        return this.tableName + ":" + this.partitionId;
    }
}

