/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.crypto;

import org.apache.flink.fs.s3base.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.kms.AWSKMS;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.S3Direct;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.crypto.S3CryptoModuleAE;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.internal.crypto.S3ObjectWrapper;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CryptoConfiguration;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.CryptoMode;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.EncryptionMaterialsProvider;

class S3CryptoModuleAEStrict
extends S3CryptoModuleAE {
    S3CryptoModuleAEStrict(AWSKMS kms, S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, s3, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
        if (cryptoConfig.getCryptoMode() != CryptoMode.StrictAuthenticatedEncryption) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final boolean isStrict() {
        return true;
    }

    @Override
    protected void securityCheck(ContentCryptoMaterial cekMaterial, S3ObjectWrapper retrieved) {
        if (!ContentCryptoScheme.AES_GCM.equals(cekMaterial.getContentCryptoScheme())) {
            throw new SecurityException("S3 object [bucket: " + retrieved.getBucketName() + ", key: " + retrieved.getKey() + "] not encrypted using authenticated encryption");
        }
    }
}

