/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.nativeio;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.fs.s3base.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.HardLink;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathIOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.IOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.SecureIOUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.nativeio.Errno;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.NativeCodeLoader;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.PerformanceAdvisory;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NativeIO {
    private static boolean workaroundNonThreadSafePasswdCalls = false;
    private static final Logger LOG = LoggerFactory.getLogger(NativeIO.class);
    private static boolean nativeLoaded = false;
    private static final Map<Long, CachedUid> uidCache;
    private static long cacheTimeout;
    private static boolean initialized;

    public static boolean isAvailable() {
        return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
    }

    private static native void initNative();

    static long getMemlockLimit() {
        return NativeIO.isAvailable() ? NativeIO.getMemlockLimit0() : 0L;
    }

    private static native long getMemlockLimit0();

    static long getOperatingSystemPageSize() {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            Unsafe unsafe = (Unsafe)f.get(null);
            return unsafe.pageSize();
        }
        catch (Throwable e) {
            LOG.warn("Unable to get operating system page size.  Guessing 4096.", e);
            return 4096L;
        }
    }

    private static String stripDomain(String name) {
        int i = name.indexOf(92);
        if (i != -1) {
            name = name.substring(i + 1);
        }
        return name;
    }

    public static String getOwner(FileDescriptor fd) throws IOException {
        NativeIO.ensureInitialized();
        if (Shell.WINDOWS) {
            String owner = Windows.getOwner(fd);
            owner = NativeIO.stripDomain(owner);
            return owner;
        }
        long uid = POSIX.getUIDforFDOwnerforOwner(fd);
        CachedUid cUid = uidCache.get(uid);
        long now = System.currentTimeMillis();
        if (cUid != null && cUid.timestamp + cacheTimeout > now) {
            return cUid.username;
        }
        String user = POSIX.getUserName(uid);
        LOG.info("Got UserName " + user + " for UID " + uid + " from the native implementation");
        cUid = new CachedUid(user, now);
        uidCache.put(uid, cUid);
        return user;
    }

    public static FileDescriptor getShareDeleteFileDescriptor(File f, long seekOffset) throws IOException {
        if (!Shell.WINDOWS) {
            RandomAccessFile rf = new RandomAccessFile(f, "r");
            if (seekOffset > 0L) {
                rf.seek(seekOffset);
            }
            return rf.getFD();
        }
        FileDescriptor fd = Windows.createFile(f.getAbsolutePath(), 0x80000000L, 7L, 3L);
        if (seekOffset > 0L) {
            Windows.setFilePointer(fd, seekOffset, 0L);
        }
        return fd;
    }

    public static FileOutputStream getCreateForWriteFileOutputStream(File f, int permissions) throws IOException {
        if (!Shell.WINDOWS) {
            try {
                FileDescriptor fd = POSIX.open(f.getAbsolutePath(), POSIX.O_WRONLY | POSIX.O_CREAT | POSIX.O_EXCL, permissions);
                return new FileOutputStream(fd);
            }
            catch (NativeIOException nioe) {
                if (nioe.getErrno() == Errno.EEXIST) {
                    throw new SecureIOUtils.AlreadyExistsException(nioe);
                }
                throw nioe;
            }
        }
        try {
            FileDescriptor fd = Windows.createFile(f.getCanonicalPath(), 0x40000000L, 7L, 1L);
            POSIX.chmod(f.getCanonicalPath(), permissions);
            return new FileOutputStream(fd);
        }
        catch (NativeIOException nioe) {
            if (nioe.getErrorCode() == 80L) {
                throw new SecureIOUtils.AlreadyExistsException(nioe);
            }
            throw nioe;
        }
    }

    private static synchronized void ensureInitialized() {
        if (!initialized) {
            cacheTimeout = new Configuration().getLong("hadoop.security.uid.cache.secs", 14400L) * 1000L;
            LOG.info("Initialized cache for UID to User mapping with a cache timeout of " + cacheTimeout / 1000L + " seconds.");
            initialized = true;
        }
    }

    public static void renameTo(File src, File dst) throws IOException {
        if (!nativeLoaded) {
            if (!src.renameTo(dst)) {
                throw new IOException("renameTo(src=" + src + ", dst=" + dst + ") failed.");
            }
        } else {
            NativeIO.renameTo0(src.getAbsolutePath(), dst.getAbsolutePath());
        }
    }

    @Deprecated
    public static void link(File src, File dst) throws IOException {
        if (!nativeLoaded) {
            HardLink.createHardLink(src, dst);
        } else {
            NativeIO.link0(src.getAbsolutePath(), dst.getAbsolutePath());
        }
    }

    private static native void renameTo0(String var0, String var1) throws NativeIOException;

    private static native void link0(String var0, String var1) throws NativeIOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFileUnbuffered(File src, File dst) throws IOException {
        if (nativeLoaded && Shell.WINDOWS) {
            NativeIO.copyFileUnbuffered0(src.getAbsolutePath(), dst.getAbsolutePath());
            return;
        }
        FileInputStream fis = new FileInputStream(src);
        FileChannel input = null;
        try {
            input = fis.getChannel();
            try (FileOutputStream fos = new FileOutputStream(dst);
                 FileChannel output = fos.getChannel();){
                long remaining = input.size();
                long position = 0L;
                long transferred = 0L;
                while (remaining > 0L) {
                    transferred = input.transferTo(position, remaining, output);
                    remaining -= transferred;
                    position += transferred;
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(LOG, input, fis);
            throw throwable;
        }
        IOUtils.cleanupWithLogger(LOG, input, fis);
    }

    private static native void copyFileUnbuffered0(String var0, String var1) throws NativeIOException;

    static {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            try {
                NativeIO.initNative();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                PerformanceAdvisory.LOG.debug("Unable to initialize NativeIO libraries", t);
            }
        }
        uidCache = new ConcurrentHashMap<Long, CachedUid>();
        initialized = false;
    }

    private static class CachedUid {
        final long timestamp;
        final String username;

        public CachedUid(String username, long timestamp) {
            this.timestamp = timestamp;
            this.username = username;
        }
    }

    public static class Windows {
        public static final long GENERIC_READ = 0x80000000L;
        public static final long GENERIC_WRITE = 0x40000000L;
        public static final long FILE_SHARE_READ = 1L;
        public static final long FILE_SHARE_WRITE = 2L;
        public static final long FILE_SHARE_DELETE = 4L;
        public static final long CREATE_NEW = 1L;
        public static final long CREATE_ALWAYS = 2L;
        public static final long OPEN_EXISTING = 3L;
        public static final long OPEN_ALWAYS = 4L;
        public static final long TRUNCATE_EXISTING = 5L;
        public static final long FILE_BEGIN = 0L;
        public static final long FILE_CURRENT = 1L;
        public static final long FILE_END = 2L;
        public static final long FILE_ATTRIBUTE_NORMAL = 128L;

        public static void createDirectoryWithMode(File path, int mode) throws IOException {
            Windows.createDirectoryWithMode0(path.getAbsolutePath(), mode);
        }

        private static native void createDirectoryWithMode0(String var0, int var1) throws NativeIOException;

        public static native FileDescriptor createFile(String var0, long var1, long var3, long var5) throws IOException;

        public static FileOutputStream createFileOutputStreamWithMode(File path, boolean append, int mode) throws IOException {
            long desiredAccess = 0x40000000L;
            long shareMode = 3L;
            long creationDisposition = append ? 4L : 2L;
            return new FileOutputStream(Windows.createFileWithMode0(path.getAbsolutePath(), desiredAccess, shareMode, creationDisposition, mode));
        }

        private static native FileDescriptor createFileWithMode0(String var0, long var1, long var3, long var5, int var7) throws NativeIOException;

        public static native long setFilePointer(FileDescriptor var0, long var1, long var3) throws IOException;

        private static native String getOwner(FileDescriptor var0) throws IOException;

        private static native boolean access0(String var0, int var1);

        public static boolean access(String path, AccessRight desiredAccess) throws IOException {
            return Windows.access0(path, desiredAccess.accessRight());
        }

        public static native void extendWorkingSetSize(long var0) throws IOException;

        static {
            if (NativeCodeLoader.isNativeCodeLoaded()) {
                try {
                    NativeIO.initNative();
                    nativeLoaded = true;
                }
                catch (Throwable t) {
                    PerformanceAdvisory.LOG.debug("Unable to initialize NativeIO libraries", t);
                }
            }
        }

        public static enum AccessRight {
            ACCESS_READ(1),
            ACCESS_WRITE(2),
            ACCESS_EXECUTE(32);

            private final int accessRight;

            private AccessRight(int access) {
                this.accessRight = access;
            }

            public int accessRight() {
                return this.accessRight;
            }
        }
    }

    public static class POSIX {
        public static int O_RDONLY = -1;
        public static int O_WRONLY = -1;
        public static int O_RDWR = -1;
        public static int O_CREAT = -1;
        public static int O_EXCL = -1;
        public static int O_NOCTTY = -1;
        public static int O_TRUNC = -1;
        public static int O_APPEND = -1;
        public static int O_NONBLOCK = -1;
        public static int O_SYNC = -1;
        public static int POSIX_FADV_NORMAL = -1;
        public static int POSIX_FADV_RANDOM = -1;
        public static int POSIX_FADV_SEQUENTIAL = -1;
        public static int POSIX_FADV_WILLNEED = -1;
        public static int POSIX_FADV_DONTNEED = -1;
        public static int POSIX_FADV_NOREUSE = -1;
        public static int SYNC_FILE_RANGE_WAIT_BEFORE = 1;
        public static int SYNC_FILE_RANGE_WRITE = 2;
        public static int SYNC_FILE_RANGE_WAIT_AFTER = 4;
        private static final Logger LOG = LoggerFactory.getLogger(NativeIO.class);
        public static boolean fadvisePossible = false;
        private static boolean nativeLoaded = false;
        private static boolean syncFileRangePossible = true;
        static final String WORKAROUND_NON_THREADSAFE_CALLS_KEY = "hadoop.workaround.non.threadsafe.getpwuid";
        static final boolean WORKAROUND_NON_THREADSAFE_CALLS_DEFAULT = true;
        private static long cacheTimeout = -1L;
        private static CacheManipulator cacheManipulator = new CacheManipulator();
        private static final Map<Integer, CachedName> USER_ID_NAME_CACHE;
        private static final Map<Integer, CachedName> GROUP_ID_NAME_CACHE;
        public static final int MMAP_PROT_READ = 1;
        public static final int MMAP_PROT_WRITE = 2;
        public static final int MMAP_PROT_EXEC = 4;

        public static CacheManipulator getCacheManipulator() {
            return cacheManipulator;
        }

        public static void setCacheManipulator(CacheManipulator cacheManipulator) {
            POSIX.cacheManipulator = cacheManipulator;
        }

        public static boolean isAvailable() {
            return NativeCodeLoader.isNativeCodeLoaded() && nativeLoaded;
        }

        private static void assertCodeLoaded() throws IOException {
            if (!POSIX.isAvailable()) {
                throw new IOException("NativeIO was not loaded");
            }
        }

        public static native FileDescriptor open(String var0, int var1, int var2) throws IOException;

        private static native Stat fstat(FileDescriptor var0) throws IOException;

        private static native Stat stat(String var0) throws IOException;

        private static native void chmodImpl(String var0, int var1) throws IOException;

        public static void chmod(String path, int mode) throws IOException {
            if (!Shell.WINDOWS) {
                POSIX.chmodImpl(path, mode);
            } else {
                try {
                    POSIX.chmodImpl(path, mode);
                }
                catch (NativeIOException nioe) {
                    if (nioe.getErrorCode() == 3L) {
                        throw new NativeIOException("No such file or directory", Errno.ENOENT);
                    }
                    LOG.warn(String.format("NativeIO.chmod error (%d): %s", nioe.getErrorCode(), nioe.getMessage()));
                    throw new NativeIOException("Unknown error", Errno.UNKNOWN);
                }
            }
        }

        static native void posix_fadvise(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

        static native void sync_file_range(FileDescriptor var0, long var1, long var3, int var5) throws NativeIOException;

        static void posixFadviseIfPossible(String identifier, FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
            if (nativeLoaded && fadvisePossible) {
                try {
                    POSIX.posix_fadvise(fd, offset, len, flags);
                }
                catch (UnsatisfiedLinkError ule) {
                    fadvisePossible = false;
                }
            }
        }

        public static void syncFileRangeIfPossible(FileDescriptor fd, long offset, long nbytes, int flags) throws NativeIOException {
            if (nativeLoaded && syncFileRangePossible) {
                try {
                    POSIX.sync_file_range(fd, offset, nbytes, flags);
                }
                catch (UnsupportedOperationException uoe) {
                    syncFileRangePossible = false;
                }
                catch (UnsatisfiedLinkError ule) {
                    syncFileRangePossible = false;
                }
            }
        }

        static native void mlock_native(ByteBuffer var0, long var1) throws NativeIOException;

        static void mlock(ByteBuffer buffer, long len) throws IOException {
            POSIX.assertCodeLoaded();
            if (!buffer.isDirect()) {
                throw new IOException("Cannot mlock a non-direct ByteBuffer");
            }
            POSIX.mlock_native(buffer, len);
        }

        public static void munmap(MappedByteBuffer buffer) {
            if (buffer instanceof DirectBuffer) {
                Cleaner cleaner = ((DirectBuffer)((Object)buffer)).cleaner();
                cleaner.clean();
            }
        }

        private static native long getUIDforFDOwnerforOwner(FileDescriptor var0) throws IOException;

        private static native String getUserName(long var0) throws IOException;

        public static Stat getFstat(FileDescriptor fd) throws IOException {
            Stat stat = null;
            if (!Shell.WINDOWS) {
                stat = POSIX.fstat(fd);
                stat.owner = POSIX.getName(IdCache.USER, stat.ownerId);
                stat.group = POSIX.getName(IdCache.GROUP, stat.groupId);
            } else {
                try {
                    stat = POSIX.fstat(fd);
                }
                catch (NativeIOException nioe) {
                    if (nioe.getErrorCode() == 6L) {
                        throw new NativeIOException("The handle is invalid.", Errno.EBADF);
                    }
                    LOG.warn(String.format("NativeIO.getFstat error (%d): %s", nioe.getErrorCode(), nioe.getMessage()));
                    throw new NativeIOException("Unknown error", Errno.UNKNOWN);
                }
            }
            return stat;
        }

        public static Stat getStat(String path) throws IOException {
            if (path == null) {
                String errMessage = "Path is null";
                LOG.warn(errMessage);
                throw new IOException(errMessage);
            }
            Stat stat = null;
            try {
                if (!Shell.WINDOWS) {
                    stat = POSIX.stat(path);
                    stat.owner = POSIX.getName(IdCache.USER, stat.ownerId);
                    stat.group = POSIX.getName(IdCache.GROUP, stat.groupId);
                } else {
                    stat = POSIX.stat(path);
                }
            }
            catch (NativeIOException nioe) {
                LOG.warn("NativeIO.getStat error ({}): {} -- file path: {}", new Object[]{nioe.getErrorCode(), nioe.getMessage(), path});
                throw new PathIOException(path, nioe);
            }
            return stat;
        }

        private static String getName(IdCache domain, int id) throws IOException {
            String name;
            Map<Integer, CachedName> idNameCache = domain == IdCache.USER ? USER_ID_NAME_CACHE : GROUP_ID_NAME_CACHE;
            CachedName cachedName = idNameCache.get(id);
            long now = System.currentTimeMillis();
            if (cachedName != null && cachedName.timestamp + cacheTimeout > now) {
                name = cachedName.name;
            } else {
                String string = name = domain == IdCache.USER ? POSIX.getUserName(id) : POSIX.getGroupName(id);
                if (LOG.isDebugEnabled()) {
                    String type = domain == IdCache.USER ? "UserName" : "GroupName";
                    LOG.debug("Got " + type + " " + name + " for ID " + id + " from the native implementation");
                }
                cachedName = new CachedName(name, now);
                idNameCache.put(id, cachedName);
            }
            return name;
        }

        static native String getUserName(int var0) throws IOException;

        static native String getGroupName(int var0) throws IOException;

        public static native long mmap(FileDescriptor var0, int var1, boolean var2, long var3) throws IOException;

        public static native void munmap(long var0, long var2) throws IOException;

        static {
            if (NativeCodeLoader.isNativeCodeLoaded()) {
                try {
                    Configuration conf = new Configuration();
                    workaroundNonThreadSafePasswdCalls = conf.getBoolean(WORKAROUND_NON_THREADSAFE_CALLS_KEY, true);
                    NativeIO.initNative();
                    nativeLoaded = true;
                    cacheTimeout = conf.getLong("hadoop.security.uid.cache.secs", 14400L) * 1000L;
                    LOG.debug("Initialized cache for IDs to User/Group mapping with a  cache timeout of " + cacheTimeout / 1000L + " seconds.");
                }
                catch (Throwable t) {
                    PerformanceAdvisory.LOG.debug("Unable to initialize NativeIO libraries", t);
                }
            }
            USER_ID_NAME_CACHE = new ConcurrentHashMap<Integer, CachedName>();
            GROUP_ID_NAME_CACHE = new ConcurrentHashMap<Integer, CachedName>();
        }

        private static enum IdCache {
            USER,
            GROUP;

        }

        private static class CachedName {
            final long timestamp;
            final String name;

            public CachedName(String name, long timestamp) {
                this.name = name;
                this.timestamp = timestamp;
            }
        }

        public static class Stat {
            private int ownerId;
            private int groupId;
            private String owner;
            private String group;
            private int mode;
            public static int S_IFMT = -1;
            public static int S_IFIFO = -1;
            public static int S_IFCHR = -1;
            public static int S_IFDIR = -1;
            public static int S_IFBLK = -1;
            public static int S_IFREG = -1;
            public static int S_IFLNK = -1;
            public static int S_IFSOCK = -1;
            public static int S_ISUID = -1;
            public static int S_ISGID = -1;
            public static int S_ISVTX = -1;
            public static int S_IRUSR = -1;
            public static int S_IWUSR = -1;
            public static int S_IXUSR = -1;

            Stat(int ownerId, int groupId, int mode) {
                this.ownerId = ownerId;
                this.groupId = groupId;
                this.mode = mode;
            }

            Stat(String owner, String group, int mode) {
                this.owner = !Shell.WINDOWS ? owner : NativeIO.stripDomain(owner);
                this.group = !Shell.WINDOWS ? group : NativeIO.stripDomain(group);
                this.mode = mode;
            }

            public String toString() {
                return "Stat(owner='" + this.owner + "', group='" + this.group + "', mode=" + this.mode + ")";
            }

            public String getOwner() {
                return this.owner;
            }

            public String getGroup() {
                return this.group;
            }

            public int getMode() {
                return this.mode;
            }
        }

        @VisibleForTesting
        public static class NoMlockCacheManipulator
        extends CacheManipulator {
            @Override
            public void mlock(String identifier, ByteBuffer buffer, long len) throws IOException {
                LOG.info("mlocking " + identifier);
            }

            @Override
            public long getMemlockLimit() {
                return 0x4000000000000L;
            }

            @Override
            public long getOperatingSystemPageSize() {
                return 4096L;
            }

            @Override
            public boolean verifyCanMlock() {
                return true;
            }
        }

        @VisibleForTesting
        public static class CacheManipulator {
            public void mlock(String identifier, ByteBuffer buffer, long len) throws IOException {
                POSIX.mlock(buffer, len);
            }

            public long getMemlockLimit() {
                return NativeIO.getMemlockLimit();
            }

            public long getOperatingSystemPageSize() {
                return NativeIO.getOperatingSystemPageSize();
            }

            public void posixFadviseIfPossible(String identifier, FileDescriptor fd, long offset, long len, int flags) throws NativeIOException {
                POSIX.posixFadviseIfPossible(identifier, fd, offset, len, flags);
            }

            public boolean verifyCanMlock() {
                return NativeIO.isAvailable();
            }
        }
    }
}

