/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.crypto;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public enum CipherSuite {
    UNKNOWN("Unknown", 0),
    AES_CTR_NOPADDING("AES/CTR/NoPadding", 16);

    private final String name;
    private final int algoBlockSize;
    private Integer unknownValue = null;

    private CipherSuite(String name, int algoBlockSize) {
        this.name = name;
        this.algoBlockSize = algoBlockSize;
    }

    public void setUnknownValue(int unknown) {
        this.unknownValue = unknown;
    }

    public int getUnknownValue() {
        return this.unknownValue;
    }

    public String getName() {
        return this.name;
    }

    public int getAlgorithmBlockSize() {
        return this.algoBlockSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("name: " + this.name);
        builder.append(", algorithmBlockSize: " + this.algoBlockSize);
        if (this.unknownValue != null) {
            builder.append(", unknownValue: " + this.unknownValue);
        }
        builder.append("}");
        return builder.toString();
    }

    public static CipherSuite convert(String name) {
        CipherSuite[] suites;
        for (CipherSuite suite : suites = CipherSuite.values()) {
            if (!suite.getName().equals(name)) continue;
            return suite;
        }
        throw new IllegalArgumentException("Invalid cipher suite name: " + name);
    }

    public String getConfigSuffix() {
        String[] parts = this.name.split("/");
        StringBuilder suffix = new StringBuilder();
        for (String part : parts) {
            suffix.append(".").append(StringUtils.toLowerCase(part));
        }
        return suffix.toString();
    }
}

