/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.io.airlift.configuration;

import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.annotations.Beta;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigBinder;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigurationAwareModule;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigurationFactory;

@Beta
public abstract class AbstractConfigurationAwareModule
implements ConfigurationAwareModule {
    private ConfigurationFactory configurationFactory;
    private Binder binder;

    @Override
    public synchronized void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = Objects.requireNonNull(configurationFactory, "configurationFactory is null");
    }

    public final synchronized void configure(Binder binder) {
        Preconditions.checkState(this.binder == null, "re-entry not allowed");
        this.binder = Objects.requireNonNull(binder, "binder is null");
        try {
            this.setup(binder);
        }
        finally {
            this.binder = null;
        }
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass) {
        ConfigBinder.configBinder(this.binder).bindConfig(configClass);
        return this.configurationFactory.build(configClass);
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass, String prefix) {
        ConfigBinder.configBinder(this.binder).bindConfig(configClass, prefix);
        return this.configurationFactory.build(configClass, prefix);
    }

    protected synchronized void install(Module module) {
        if (module instanceof ConfigurationAwareModule) {
            ((ConfigurationAwareModule)module).setConfigurationFactory(this.configurationFactory);
        }
        this.binder.install(module);
    }

    protected abstract void setup(Binder var1);
}

