/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.security.Privilege;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.security.PrivilegeInfo;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;

public class HivePrivilegeInfo {
    private final HivePrivilege hivePrivilege;
    private final boolean grantOption;

    public HivePrivilegeInfo(HivePrivilege hivePrivilege, boolean grantOption) {
        this.hivePrivilege = hivePrivilege;
        this.grantOption = grantOption;
    }

    public HivePrivilege getHivePrivilege() {
        return this.hivePrivilege;
    }

    public boolean isGrantOption() {
        return this.grantOption;
    }

    public HivePrivilegeInfo withGrantOption(boolean grantOption) {
        return new HivePrivilegeInfo(this.hivePrivilege, grantOption);
    }

    public static Set<HivePrivilegeInfo> parsePrivilege(PrivilegeGrantInfo userGrant) {
        String name;
        boolean withGrantOption = userGrant.isGrantOption();
        switch (name = userGrant.getPrivilege().toUpperCase(Locale.ENGLISH)) {
            case "ALL": {
                return Arrays.asList(HivePrivilege.values()).stream().map(hivePrivilege -> new HivePrivilegeInfo((HivePrivilege)((Object)hivePrivilege), withGrantOption)).collect(Collectors.toSet());
            }
            case "SELECT": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilege.SELECT, withGrantOption));
            }
            case "INSERT": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilege.INSERT, withGrantOption));
            }
            case "UPDATE": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilege.UPDATE, withGrantOption));
            }
            case "DELETE": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilege.DELETE, withGrantOption));
            }
            case "OWNERSHIP": {
                return ImmutableSet.of(new HivePrivilegeInfo(HivePrivilege.OWNERSHIP, withGrantOption));
            }
        }
        return ImmutableSet.of();
    }

    public static HivePrivilege toHivePrivilege(Privilege privilege) {
        switch (privilege) {
            case SELECT: {
                return HivePrivilege.SELECT;
            }
            case INSERT: {
                return HivePrivilege.INSERT;
            }
            case DELETE: {
                return HivePrivilege.DELETE;
            }
            case UPDATE: {
                return HivePrivilege.UPDATE;
            }
        }
        return null;
    }

    public boolean isContainedIn(HivePrivilegeInfo hivePrivilegeInfo) {
        return this.getHivePrivilege().equals((Object)hivePrivilegeInfo.getHivePrivilege()) && (this.isGrantOption() == hivePrivilegeInfo.isGrantOption() || !this.isGrantOption() && hivePrivilegeInfo.isGrantOption());
    }

    public Set<PrivilegeInfo> toPrivilegeInfo() {
        switch (this.getHivePrivilege()) {
            case SELECT: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.SELECT, this.isGrantOption()));
            }
            case INSERT: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.INSERT, this.isGrantOption()));
            }
            case DELETE: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.DELETE, this.isGrantOption()));
            }
            case UPDATE: {
                return ImmutableSet.of(new PrivilegeInfo(Privilege.UPDATE, this.isGrantOption()));
            }
            case OWNERSHIP: {
                return Arrays.asList(Privilege.values()).stream().map(privilege -> new PrivilegeInfo(privilege, Boolean.TRUE.booleanValue())).collect(Collectors.toSet());
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hivePrivilege, this.grantOption});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HivePrivilegeInfo hivePrivilegeInfo = (HivePrivilegeInfo)o;
        return Objects.equals((Object)this.hivePrivilege, (Object)hivePrivilegeInfo.hivePrivilege) && Objects.equals(this.grantOption, hivePrivilegeInfo.grantOption);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("privilege", (Object)this.hivePrivilege).add("grantOption", this.grantOption).toString();
    }

    public static enum HivePrivilege {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        OWNERSHIP;

    }
}

