/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.HadoopFileSystemCache;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hadoop.HadoopNative;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsConfiguration;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.GenericExceptionAction;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HdfsAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.security.Identity;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;

public class HdfsEnvironment {
    private final HdfsConfiguration hdfsConfiguration;
    private final HdfsAuthentication hdfsAuthentication;
    private final boolean verifyChecksum;

    @Inject
    public HdfsEnvironment(HdfsConfiguration hdfsConfiguration, HiveClientConfig config, HdfsAuthentication hdfsAuthentication) {
        this.hdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hdfsConfiguration is null");
        this.verifyChecksum = Objects.requireNonNull(config, "config is null").isVerifyChecksum();
        this.hdfsAuthentication = Objects.requireNonNull(hdfsAuthentication, "hdfsAuthentication is null");
    }

    public Configuration getConfiguration(HdfsContext context, Path path) {
        return this.hdfsConfiguration.getConfiguration(context, path.toUri());
    }

    public FileSystem getFileSystem(HdfsContext context, Path path) throws IOException {
        return this.getFileSystem(context.getIdentity().getUser(), path, this.getConfiguration(context, path));
    }

    public FileSystem getFileSystem(String user, Path path, Configuration configuration) throws IOException {
        return this.hdfsAuthentication.doAs(user, () -> {
            FileSystem fileSystem = path.getFileSystem(configuration);
            fileSystem.setVerifyChecksum(this.verifyChecksum);
            return fileSystem;
        });
    }

    public <R, E extends Exception> R doAs(String user, GenericExceptionAction<R, E> action) throws E {
        return this.hdfsAuthentication.doAs(user, action);
    }

    public void doAs(String user, Runnable action) {
        this.hdfsAuthentication.doAs(user, action);
    }

    static {
        HadoopNative.requireHadoopNative();
        HadoopFileSystemCache.initialize();
    }

    public static class HdfsContext {
        private final Identity identity;
        private final Optional<String> source;
        private final Optional<String> queryId;
        private final Optional<String> schemaName;
        private final Optional<String> tableName;

        public HdfsContext(Identity identity) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.source = Optional.empty();
            this.queryId = Optional.empty();
            this.schemaName = Optional.empty();
            this.tableName = Optional.empty();
        }

        public HdfsContext(ConnectorSession session, String schemaName) {
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(schemaName, "schemaName is null");
            this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
            this.source = Objects.requireNonNull(session.getSource(), "session.getSource()");
            this.queryId = Optional.of(session.getQueryId());
            this.schemaName = Optional.of(schemaName);
            this.tableName = Optional.empty();
        }

        public HdfsContext(ConnectorSession session, String schemaName, String tableName) {
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(schemaName, "schemaName is null");
            Objects.requireNonNull(tableName, "tableName is null");
            this.identity = Objects.requireNonNull(session.getIdentity(), "session.getIdentity() is null");
            this.source = Objects.requireNonNull(session.getSource(), "session.getSource()");
            this.queryId = Optional.of(session.getQueryId());
            this.schemaName = Optional.of(schemaName);
            this.tableName = Optional.of(tableName);
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public Optional<String> getSource() {
            return this.source;
        }

        public Optional<String> getQueryId() {
            return this.queryId;
        }

        public Optional<String> getSchemaName() {
            return this.schemaName;
        }

        public Optional<String> getTableName() {
            return this.tableName;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("user", this.identity).add("source", this.source.orElse(null)).add("queryId", this.queryId.orElse(null)).add("schemaName", this.schemaName.orElse(null)).add("tableName", this.tableName.orElse(null)).toString();
        }
    }
}

