/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.List;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.PaginatedList;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ScanRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ScanResult;

public class PaginatedScanList<T>
extends PaginatedList<T> {
    private final ScanRequest scanRequest;
    private final DynamoDBMapperConfig config;
    private ScanResult scanResult;

    public PaginatedScanList(DynamoDBMapper mapper, Class<T> clazz, AmazonDynamoDB dynamo, ScanRequest scanRequest, ScanResult scanResult, DynamoDBMapperConfig.PaginationLoadingStrategy paginationLoadingStrategy, DynamoDBMapperConfig config) {
        super(mapper, clazz, dynamo, paginationLoadingStrategy);
        this.scanRequest = scanRequest;
        this.scanResult = scanResult;
        this.config = config;
        this.allResults.addAll(mapper.marshallIntoObjects(mapper.toParameters(scanResult.getItems(), clazz, scanRequest.getTableName(), config)));
        if (paginationLoadingStrategy == DynamoDBMapperConfig.PaginationLoadingStrategy.EAGER_LOADING) {
            this.loadAllResults();
        }
    }

    @Override
    protected boolean atEndOfResults() {
        return this.scanResult.getLastEvaluatedKey() == null;
    }

    @Override
    protected synchronized List<T> fetchNextPage() {
        this.scanRequest.setExclusiveStartKey(this.scanResult.getLastEvaluatedKey());
        this.scanResult = this.dynamo.scan(DynamoDBMapper.applyUserAgent(this.scanRequest));
        return this.mapper.marshallIntoObjects(this.mapper.toParameters(this.scanResult.getItems(), this.clazz, this.scanRequest.getTableName(), this.config));
    }
}

