/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.fs.s3base.shaded.com.google.common.collect.Sets;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.PathExistsException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging.ConflictResolution;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging.Paths;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a.commit.staging.StagingCommitter;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.JobContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionedStagingCommitter
extends StagingCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionedStagingCommitter.class);
    public static final String NAME = "partitioned";

    public PartitionedStagingCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PartitionedStagingCommitter{");
        sb.append(super.toString());
        sb.append('}');
        return sb.toString();
    }

    @Override
    protected int commitTaskInternal(TaskAttemptContext context, List<? extends FileStatus> taskOutput) throws IOException {
        Path attemptPath = this.getTaskAttemptPath(context);
        Set<String> partitions = Paths.getPartitions(attemptPath, taskOutput);
        FileSystem fs = this.getDestFS();
        if (this.getConflictResolutionMode((JobContext)context, fs.getConf()) == ConflictResolution.FAIL) {
            for (String partition : partitions) {
                Path partitionPath = this.getFinalPath(partition + "/file", (JobContext)context).getParent();
                if (!fs.exists(partitionPath)) continue;
                LOG.debug("Failing commit by task attempt {} to write to existing path {} under {}", new Object[]{context.getTaskAttemptID(), partitionPath, this.getOutputPath()});
                throw new PathExistsException(partitionPath.toString(), "Destination path exists and committer conflict resolution mode is \"fail\"");
            }
        }
        return super.commitTaskInternal(context, taskOutput);
    }

    @Override
    protected void preCommitJob(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        FileSystem fs = this.getDestFS();
        Configuration fsConf = fs.getConf();
        switch (this.getConflictResolutionMode(context, fsConf)) {
            case FAIL: {
                break;
            }
            case APPEND: {
                break;
            }
            case REPLACE: {
                Set partitions = pending.stream().map(SinglePendingCommit::destinationPath).map(Path::getParent).collect(Collectors.toCollection(Sets::newLinkedHashSet));
                for (Path partitionPath : partitions) {
                    LOG.debug("{}: removing partition path to be replaced: " + this.getRole(), (Object)partitionPath);
                    fs.delete(partitionPath, true);
                }
                break;
            }
            default: {
                throw new PathCommitException("", this.getRole() + ": unknown conflict resolution mode: " + (Object)((Object)this.getConflictResolutionMode(context, fsConf)));
            }
        }
    }
}

