/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication;

import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ForHdfs;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.ForHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.CachingKerberosHadoopAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.DirectHdfsAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HadoopAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HdfsAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HdfsKerberosConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.ImpersonatingHdfsAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.KerberosAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.KerberosHadoopAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.KerberosHiveMetastoreAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.MetastoreKerberosConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.NoHdfsAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.NoHiveMetastoreAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.authentication.SimpleHadoopAuthentication;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Key;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Provides;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Scopes;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Singleton;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigBinder;

public final class AuthenticationModules {
    private AuthenticationModules() {
    }

    public static Module noHiveMetastoreAuthenticationModule() {
        return binder -> binder.bind(HiveMetastoreAuthentication.class).to(NoHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module kerberosHiveMetastoreAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HiveMetastoreAuthentication.class).to(KerberosHiveMetastoreAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder(binder).bindConfig(MetastoreKerberosConfig.class);
            }

            @Provides
            @Singleton
            @ForHiveMetastore
            HadoopAuthentication createHadoopAuthentication(MetastoreKerberosConfig config) {
                String principal = config.getHiveMetastoreClientPrincipal();
                String keytabLocation = config.getHiveMetastoreClientKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation);
            }
        };
    }

    public static Module noHdfsAuthenticationModule() {
        return binder -> binder.bind(HdfsAuthentication.class).to(NoHdfsAuthentication.class).in(Scopes.SINGLETON);
    }

    public static Module simpleImpersonatingHdfsAuthenticationModule() {
        return binder -> {
            binder.bind(Key.get(HadoopAuthentication.class, ForHdfs.class)).to(SimpleHadoopAuthentication.class);
            binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
        };
    }

    public static Module kerberosHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(DirectHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder(binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config) {
                String principal = config.getHdfsPrestoPrincipal();
                String keytabLocation = config.getHdfsPrestoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation);
            }
        };
    }

    public static Module kerberosImpersonatingHdfsAuthenticationModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(HdfsAuthentication.class).to(ImpersonatingHdfsAuthentication.class).in(Scopes.SINGLETON);
                ConfigBinder.configBinder(binder).bindConfig(HdfsKerberosConfig.class);
            }

            @Inject
            @Provides
            @Singleton
            @ForHdfs
            HadoopAuthentication createHadoopAuthentication(HdfsKerberosConfig config) {
                String principal = config.getHdfsPrestoPrincipal();
                String keytabLocation = config.getHdfsPrestoKeytab();
                return AuthenticationModules.createCachingKerberosHadoopAuthentication(principal, keytabLocation);
            }
        };
    }

    private static HadoopAuthentication createCachingKerberosHadoopAuthentication(String principal, String keytabLocation) {
        KerberosAuthentication kerberosAuthentication = new KerberosAuthentication(principal, keytabLocation);
        KerberosHadoopAuthentication kerberosHadoopAuthentication = new KerberosHadoopAuthentication(kerberosAuthentication);
        return new CachingKerberosHadoopAuthentication(kerberosHadoopAuthentication);
    }
}

