/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.metastore.api.StorageDescriptor;

public class HiveBucketProperty {
    private final List<String> bucketedBy;
    private final int bucketCount;

    @JsonCreator
    public HiveBucketProperty(@JsonProperty(value="bucketedBy") List<String> bucketedBy, @JsonProperty(value="bucketCount") int bucketCount) {
        this.bucketedBy = Objects.requireNonNull(bucketedBy, "bucketedBy is null");
        this.bucketCount = Objects.requireNonNull(Integer.valueOf(bucketCount), "bucketCount is null");
    }

    public static Optional<HiveBucketProperty> fromStorageDescriptor(StorageDescriptor storageDescriptor, String tablePartitionName) {
        boolean numBucketsSet;
        boolean bucketColsSet = storageDescriptor.isSetBucketCols() && !storageDescriptor.getBucketCols().isEmpty();
        boolean bl = numBucketsSet = storageDescriptor.isSetNumBuckets() && storageDescriptor.getNumBuckets() > 0;
        if (!numBucketsSet) {
            return Optional.empty();
        }
        if (!bucketColsSet) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set: " + tablePartitionName);
        }
        return Optional.of(new HiveBucketProperty(storageDescriptor.getBucketCols(), storageDescriptor.getNumBuckets()));
    }

    @JsonProperty
    public List<String> getBucketedBy() {
        return this.bucketedBy;
    }

    @JsonProperty
    public int getBucketCount() {
        return this.bucketCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBucketProperty that = (HiveBucketProperty)o;
        return this.bucketCount == that.bucketCount && Objects.equals(this.bucketedBy, that.bucketedBy);
    }

    public int hashCode() {
        return Objects.hash(this.bucketedBy, this.bucketCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bucketedBy", this.bucketedBy).add("bucketCount", this.bucketCount).toString();
    }
}

