/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.IOException;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveUtil;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.SerDeUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.RecordCursor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.BigintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.BooleanType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Chars;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DateType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DecimalType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Decimals;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DoubleType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.IntegerType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.RealType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.SmallintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TimestampType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TinyintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TypeManager;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.VarbinaryType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Varchars;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Throwables;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;
import org.apache.flink.fs.s3presto.shaded.org.joda.time.DateTimeZone;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.BinaryComparable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.BytesWritable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Text;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.mapred.RecordReader;

class GenericHiveRecordCursor<K, V extends Writable>
implements RecordCursor {
    private final RecordReader<K, V> recordReader;
    private final K key;
    private final V value;
    private final Deserializer deserializer;
    private final Type[] types;
    private final HiveType[] hiveTypes;
    private final StructObjectInspector rowInspector;
    private final ObjectInspector[] fieldInspectors;
    private final StructField[] structFields;
    private final boolean[] loaded;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;
    private final long totalBytes;
    private final DateTimeZone hiveStorageTimeZone;
    private long completedBytes;
    private Object rowData;
    private boolean closed;

    public GenericHiveRecordCursor(RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        Objects.requireNonNull(recordReader, "recordReader is null");
        Preconditions.checkArgument(totalBytes >= 0L, "totalBytes is negative");
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.recordReader = recordReader;
        this.totalBytes = totalBytes;
        this.key = recordReader.createKey();
        this.value = (Writable)recordReader.createValue();
        this.hiveStorageTimeZone = hiveStorageTimeZone;
        this.deserializer = HiveUtil.getDeserializer(splitSchema);
        this.rowInspector = HiveUtil.getTableObjectInspector(this.deserializer);
        int size = columns.size();
        this.types = new Type[size];
        this.hiveTypes = new HiveType[size];
        this.structFields = new StructField[size];
        this.fieldInspectors = new ObjectInspector[size];
        this.loaded = new boolean[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int i = 0; i < columns.size(); ++i) {
            StructField field;
            HiveColumnHandle column = columns.get(i);
            Preconditions.checkState(column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR, "column type must be regular");
            this.types[i] = typeManager.getType(column.getTypeSignature());
            this.hiveTypes[i] = column.getHiveType();
            this.structFields[i] = field = this.rowInspector.getStructFieldRef(column.getName());
            this.fieldInspectors[i] = field.getFieldObjectInspector();
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getCompletedBytes() {
        if (!this.closed) {
            this.updateCompletedBytes();
        }
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    private void updateCompletedBytes() {
        try {
            long newCompletedBytes = (long)((float)this.totalBytes * this.recordReader.getProgress());
            this.completedBytes = Math.min(this.totalBytes, Math.max(this.completedBytes, newCompletedBytes));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        try {
            if (this.closed || !this.recordReader.next(this.key, this.value)) {
                this.close();
                return false;
            }
            Arrays.fill(this.loaded, false);
            this.rowData = this.deserializer.deserialize(this.value);
            return true;
        }
        catch (IOException | RuntimeException | SerDeException e) {
            HiveUtil.closeWithSuppression(this, e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, e);
        }
    }

    public boolean getBoolean(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Boolean.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseBooleanColumn(fieldId);
        }
        return this.booleans[fieldId];
    }

    private void parseBooleanColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState(fieldValue != null, "fieldValue should not be null");
            this.booleans[column] = (Boolean)fieldValue;
            this.nulls[column] = false;
        }
    }

    public long getLong(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Long.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseLongColumn(fieldId);
        }
        return this.longs[fieldId];
    }

    private void parseLongColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState(fieldValue != null, "fieldValue should not be null");
            this.longs[column] = GenericHiveRecordCursor.getLongExpressedValue(fieldValue, this.hiveStorageTimeZone);
            this.nulls[column] = false;
        }
    }

    private static long getLongExpressedValue(Object value, DateTimeZone hiveTimeZone) {
        if (value instanceof Date) {
            long storageTime = ((Date)value).getTime();
            long utcMillis = storageTime + (long)DateTimeZone.getDefault().getOffset(storageTime);
            return TimeUnit.MILLISECONDS.toDays(utcMillis);
        }
        if (value instanceof Timestamp) {
            long parsedJvmMillis = ((Timestamp)value).getTime();
            DateTimeZone jvmTimeZone = DateTimeZone.getDefault();
            long hiveMillis = jvmTimeZone.convertUTCToLocal(parsedJvmMillis);
            long utcMillis = hiveTimeZone.convertLocalToUTC(hiveMillis, false);
            return utcMillis;
        }
        if (value instanceof Float) {
            return Float.floatToRawIntBits(((Float)value).floatValue());
        }
        return ((Number)value).longValue();
    }

    public double getDouble(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Double.TYPE);
        if (!this.loaded[fieldId]) {
            this.parseDoubleColumn(fieldId);
        }
        return this.doubles[fieldId];
    }

    private void parseDoubleColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState(fieldValue != null, "fieldValue should not be null");
            this.doubles[column] = ((Number)fieldValue).doubleValue();
            this.nulls[column] = false;
        }
    }

    public Slice getSlice(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Slice.class);
        if (!this.loaded[fieldId]) {
            this.parseStringColumn(fieldId);
        }
        return this.slices[fieldId];
    }

    private void parseStringColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            BinaryComparable hiveValue;
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveWritableObject(fieldData);
            Preconditions.checkState(fieldValue != null, "fieldValue should not be null");
            if (fieldValue instanceof Text) {
                hiveValue = (Text)fieldValue;
            } else if (fieldValue instanceof BytesWritable) {
                hiveValue = (BytesWritable)fieldValue;
            } else if (fieldValue instanceof HiveVarcharWritable) {
                hiveValue = ((HiveVarcharWritable)fieldValue).getTextValue();
            } else if (fieldValue instanceof HiveCharWritable) {
                hiveValue = ((HiveCharWritable)fieldValue).getTextValue();
            } else {
                throw new IllegalStateException("unsupported string field type: " + fieldValue.getClass().getName());
            }
            Slice value = Slices.wrappedBuffer(hiveValue.getBytes(), 0, hiveValue.getLength());
            Type type = this.types[column];
            if (Varchars.isVarcharType((Type)type)) {
                value = Varchars.truncateToLength((Slice)value, (Type)type);
            }
            if (Chars.isCharType((Type)type)) {
                value = Chars.truncateToLengthAndTrimSpaces((Slice)value, (Type)type);
            }
            this.slices[column] = Slices.copyOf(value);
            this.nulls[column] = false;
        }
    }

    private void parseDecimalColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            Object fieldValue = ((PrimitiveObjectInspector)this.fieldInspectors[column]).getPrimitiveJavaObject(fieldData);
            Preconditions.checkState(fieldValue != null, "fieldValue should not be null");
            HiveDecimal decimal = (HiveDecimal)fieldValue;
            DecimalType columnType = (DecimalType)this.types[column];
            BigInteger unscaledDecimal = Decimals.rescale((BigInteger)decimal.unscaledValue(), (int)decimal.scale(), (int)columnType.getScale());
            if (columnType.isShort()) {
                this.longs[column] = unscaledDecimal.longValue();
            } else {
                this.slices[column] = Decimals.encodeUnscaledValue((BigInteger)unscaledDecimal);
            }
            this.nulls[column] = false;
        }
    }

    public Object getObject(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        this.validateType(fieldId, Block.class);
        if (!this.loaded[fieldId]) {
            this.parseObjectColumn(fieldId);
        }
        return this.objects[fieldId];
    }

    private void parseObjectColumn(int column) {
        this.loaded[column] = true;
        Object fieldData = this.rowInspector.getStructFieldData(this.rowData, this.structFields[column]);
        if (fieldData == null) {
            this.nulls[column] = true;
        } else {
            this.objects[column] = SerDeUtils.getBlockObject(this.types[column], fieldData, this.fieldInspectors[column]);
            this.nulls[column] = false;
        }
    }

    public boolean isNull(int fieldId) {
        Preconditions.checkState(!this.closed, "Cursor is closed");
        if (!this.loaded[fieldId]) {
            this.parseColumn(fieldId);
        }
        return this.nulls[fieldId];
    }

    private void parseColumn(int column) {
        Type type = this.types[column];
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            this.parseBooleanColumn(column);
        } else if (BigintType.BIGINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (RealType.REAL.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            this.parseDoubleColumn(column);
        } else if (Varchars.isVarcharType((Type)type) || VarbinaryType.VARBINARY.equals((Object)type)) {
            this.parseStringColumn(column);
        } else if (Chars.isCharType((Type)type)) {
            this.parseStringColumn(column);
        } else if (HiveUtil.isStructuralType(this.hiveTypes[column])) {
            this.parseObjectColumn(column);
        } else if (DateType.DATE.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (TimestampType.TIMESTAMP.equals((Object)type)) {
            this.parseLongColumn(column);
        } else if (type instanceof DecimalType) {
            this.parseDecimalColumn(column);
        } else {
            throw new UnsupportedOperationException("Unsupported column type: " + type);
        }
    }

    private void validateType(int fieldId, Class<?> type) {
        if (!this.types[fieldId].getJavaType().equals(type)) {
            throw new IllegalArgumentException(String.format("Expected field to be %s, actual %s (field %s)", type, this.types[fieldId], fieldId));
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.updateCompletedBytes();
        try {
            this.recordReader.close();
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
    }
}

