/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec;

import java.util.List;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.Beta;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec.Condition;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec.Operand;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec.PathOperand;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec.Precedence;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;

@Beta
public final class InCondition
extends Condition {
    private final PathOperand attribute;
    private final List<? extends Operand> operands;

    InCondition(PathOperand attribute, List<? extends Operand> operands) {
        this.attribute = attribute;
        this.operands = operands;
    }

    @Override
    String asSubstituted(SubstitutionContext context) {
        StringBuilder sb = new StringBuilder(this.attribute.asSubstituted(context)).append(" IN (");
        boolean first = true;
        for (Operand operand : this.operands) {
            if (first) {
                sb.append(operand.asSubstituted(context));
                first = false;
                continue;
            }
            sb.append(", ").append(operand.asSubstituted(context));
        }
        return sb.append(")").toString();
    }

    @Override
    boolean atomic() {
        return true;
    }

    @Override
    int precedence() {
        return Precedence.IN.value();
    }
}

