/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.server;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.fs.s3base.shaded.org.apache.http.NameValuePair;
import org.apache.flink.fs.s3base.shaded.org.apache.http.client.utils.URLEncodedUtils;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.authentication.server.AuthenticationToken;

public class PseudoAuthenticationHandler
implements AuthenticationHandler {
    public static final String TYPE = "simple";
    public static final String ANONYMOUS_ALLOWED = "simple.anonymous.allowed";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String PSEUDO_AUTH = "PseudoAuth";
    private boolean acceptAnonymous;
    private String type;

    public PseudoAuthenticationHandler() {
        this(TYPE);
    }

    public PseudoAuthenticationHandler(String type) {
        this.type = type;
    }

    @Override
    public void init(Properties config) throws ServletException {
        this.acceptAnonymous = Boolean.parseBoolean(config.getProperty(ANONYMOUS_ALLOWED, "false"));
    }

    protected boolean getAcceptAnonymous() {
        return this.acceptAnonymous;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    private String getUserName(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null || queryString.length() == 0) {
            return null;
        }
        List<NameValuePair> list = URLEncodedUtils.parse(queryString, UTF8_CHARSET);
        if (list != null) {
            for (NameValuePair nv : list) {
                if (!"user.name".equals(nv.getName())) continue;
                return nv.getValue();
            }
        }
        return null;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String userName = this.getUserName(request);
        if (userName == null) {
            if (this.getAcceptAnonymous()) {
                token = AuthenticationToken.ANONYMOUS;
            } else {
                response.setStatus(403);
                response.setHeader("WWW-Authenticate", PSEUDO_AUTH);
                token = null;
            }
        } else {
            token = new AuthenticationToken(userName, userName, this.getType());
        }
        return token;
    }
}

