/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader;

import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPage;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPageV1;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataPageV2;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetEncoding;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTypeUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetValidationUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetValuesType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.RichColumnDescriptor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetBinaryColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetBooleanColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetDecimalColumnReaderFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetDoubleColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetFloatColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetIntColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetLevelNullReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetLevelRLEReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetLevelReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetLevelValuesReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetLongColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetPageReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.reader.ParquetTimestampColumnReader;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.StandardErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.Block;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilder;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.block.BlockBuilderStatus;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.DecimalType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.values.ValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import parquet.io.ParquetDecodingException;

public abstract class ParquetColumnReader {
    protected final ColumnDescriptor columnDescriptor;
    protected int definitionLevel;
    protected ValuesReader valuesReader;
    protected int nextBatchSize;
    private ParquetLevelReader repetitionReader;
    private ParquetLevelReader definitionReader;
    private int repetitionLevel;
    private long totalValueCount;
    private ParquetPageReader pageReader;
    private ParquetDictionary dictionary;
    private int currentValueCount;
    private ParquetDataPage page;
    private int remainingValueCountInPage;
    private int readOffset;

    protected abstract void readValue(BlockBuilder var1, Type var2);

    protected abstract void skipValue();

    public static ParquetColumnReader createReader(RichColumnDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return new ParquetBooleanColumnReader(descriptor);
            }
            case INT32: {
                return ParquetColumnReader.createDecimalColumnReader(descriptor).orElse(new ParquetIntColumnReader(descriptor));
            }
            case INT64: {
                return ParquetColumnReader.createDecimalColumnReader(descriptor).orElse(new ParquetLongColumnReader(descriptor));
            }
            case INT96: {
                return new ParquetTimestampColumnReader(descriptor);
            }
            case FLOAT: {
                return new ParquetFloatColumnReader(descriptor);
            }
            case DOUBLE: {
                return new ParquetDoubleColumnReader(descriptor);
            }
            case BINARY: {
                return ParquetColumnReader.createDecimalColumnReader(descriptor).orElse(new ParquetBinaryColumnReader(descriptor));
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return ParquetColumnReader.createDecimalColumnReader(descriptor).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Parquet type FIXED_LEN_BYTE_ARRAY supported as DECIMAL; got " + descriptor.getPrimitiveType().getOriginalType()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getType());
    }

    private static Optional<ParquetColumnReader> createDecimalColumnReader(RichColumnDescriptor descriptor) {
        Optional<Type> type = ParquetTypeUtils.createDecimalType(descriptor);
        if (type.isPresent()) {
            DecimalType decimalType = (DecimalType)type.get();
            return Optional.of(ParquetDecimalColumnReaderFactory.createReader(descriptor, decimalType.getPrecision(), decimalType.getScale()));
        }
        return Optional.empty();
    }

    public ParquetColumnReader(ColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor");
        this.pageReader = null;
    }

    public ParquetPageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(ParquetPageReader pageReader) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        ParquetDictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.columnDescriptor, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + this.columnDescriptor, (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        Preconditions.checkArgument(pageReader.getTotalValueCount() > 0L, "page is empty");
        this.totalValueCount = pageReader.getTotalValueCount();
    }

    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    public ColumnDescriptor getDescriptor() {
        return this.columnDescriptor;
    }

    public Block readPrimitive(Type type, IntList positions) throws IOException {
        int valueCount;
        int numValues;
        this.seek();
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), this.nextBatchSize);
        for (valueCount = 0; valueCount < this.nextBatchSize; valueCount += numValues) {
            if (this.page == null) {
                this.readNextPage();
            }
            numValues = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount);
            this.readValues(blockBuilder, numValues, type, positions);
            this.updatePosition(numValues);
        }
        Preconditions.checkArgument(valueCount == this.nextBatchSize, "valueCount %s not equals to batchSize %s", valueCount, this.nextBatchSize);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return blockBuilder.build();
    }

    private void readValues(BlockBuilder blockBuilder, int numValues, Type type, IntList positions) {
        this.definitionLevel = this.definitionReader.readLevel();
        this.repetitionLevel = this.repetitionReader.readLevel();
        int valueCount = 0;
        for (int i = 0; i < numValues; ++i) {
            do {
                this.readValue(blockBuilder, type);
                try {
                    ++valueCount;
                    this.repetitionLevel = this.repetitionReader.readLevel();
                    if (this.repetitionLevel == 0) {
                        positions.add(valueCount);
                        valueCount = 0;
                        if (i == numValues - 1) {
                            return;
                        }
                    }
                    this.definitionLevel = this.definitionReader.readLevel();
                }
                catch (IllegalArgumentException expected) {
                    positions.add(valueCount);
                    return;
                }
            } while (this.repetitionLevel != 0);
        }
    }

    private void skipValues(int offset) {
        this.definitionLevel = this.definitionReader.readLevel();
        this.repetitionLevel = this.repetitionReader.readLevel();
        for (int i = 0; i < offset; ++i) {
            do {
                this.skipValue();
                try {
                    this.repetitionLevel = this.repetitionReader.readLevel();
                    if (i == offset - 1 && this.repetitionLevel == 0) {
                        return;
                    }
                    this.definitionLevel = this.definitionReader.readLevel();
                }
                catch (IllegalArgumentException expected) {
                    return;
                }
            } while (this.repetitionLevel != 0);
        }
    }

    private void seek() throws IOException {
        int valuePosition;
        int offset;
        Preconditions.checkArgument((long)this.currentValueCount <= this.totalValueCount, "Already read all values in column chunk");
        if (this.readOffset == 0) {
            return;
        }
        for (valuePosition = 0; valuePosition < this.readOffset; valuePosition += offset) {
            if (this.page == null) {
                this.readNextPage();
            }
            offset = Math.min(this.remainingValueCountInPage, this.readOffset - valuePosition);
            this.skipValues(offset);
            this.updatePosition(offset);
        }
        Preconditions.checkArgument(valuePosition == this.readOffset, "valuePosition %s must be equal to readOffset %s", valuePosition, this.readOffset);
    }

    private void readNextPage() throws IOException {
        this.page = this.pageReader.readPage();
        ParquetValidationUtils.validateParquet(this.page != null, "Not enough values to read in column chunk", new Object[0]);
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof ParquetDataPageV1 ? this.readPageV1((ParquetDataPageV1)this.page) : this.readPageV2((ParquetDataPageV2)this.page);
    }

    private void updatePosition(int numValues) {
        if (numValues == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= numValues;
        this.currentValueCount += numValues;
    }

    private ValuesReader readPageV1(ParquetDataPageV1 page) {
        ValuesReader rlReader = page.getRepetitionLevelEncoding().getValuesReader(this.columnDescriptor, ParquetValuesType.REPETITION_LEVEL);
        ValuesReader dlReader = page.getDefinitionLevelEncoding().getValuesReader(this.columnDescriptor, ParquetValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new ParquetLevelValuesReader(rlReader);
        this.definitionReader = new ParquetLevelValuesReader(dlReader);
        try {
            byte[] bytes = page.getSlice().getBytes();
            rlReader.initFromPage(page.getValueCount(), bytes, 0);
            int offset = rlReader.getNextOffset();
            dlReader.initFromPage(page.getValueCount(), bytes, offset);
            offset = dlReader.getNextOffset();
            return this.initDataReader(page.getValueEncoding(), bytes, offset, page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + this.columnDescriptor, (Throwable)e);
        }
    }

    private ValuesReader readPageV2(ParquetDataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        return this.initDataReader(page.getDataEncoding(), page.getSlice().getBytes(), 0, page.getValueCount());
    }

    private ParquetLevelReader buildLevelRLEReader(int maxLevel, Slice slice) {
        if (maxLevel == 0) {
            return new ParquetLevelNullReader();
        }
        return new ParquetLevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), new ByteArrayInputStream(slice.getBytes())));
    }

    private ValuesReader initDataReader(ParquetEncoding dataEncoding, byte[] bytes, int offset, int valueCount) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.columnDescriptor, ParquetValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.columnDescriptor, ParquetValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(valueCount, bytes, offset);
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + this.columnDescriptor, (Throwable)e);
        }
    }
}

