/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetCorruptionException;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.io.airlift.compress.Decompressor;
import org.apache.flink.fs.s3presto.shaded.io.airlift.compress.lzo.LzoDecompressor;
import org.apache.flink.fs.s3presto.shaded.io.airlift.compress.snappy.SnappyDecompressor;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.DynamicSliceOutput;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;
import parquet.hadoop.metadata.CompressionCodecName;
import sun.misc.Unsafe;

public final class ParquetCompressionUtils {
    private static final int GZIP_BUFFER_SIZE = 8192;

    private ParquetCompressionUtils() {
    }

    public static Slice decompress(CompressionCodecName codec, Slice input, int uncompressedSize) throws IOException {
        Objects.requireNonNull(input, "input is null");
        if (input.length() == 0) {
            return Slices.EMPTY_SLICE;
        }
        switch (codec) {
            case GZIP: {
                return ParquetCompressionUtils.decompressGzip(input, uncompressedSize);
            }
            case SNAPPY: {
                return ParquetCompressionUtils.decompressSnappy(input, uncompressedSize);
            }
            case UNCOMPRESSED: {
                return input;
            }
            case LZO: {
                return ParquetCompressionUtils.decompressLZO(input, uncompressedSize);
            }
        }
        throw new ParquetCorruptionException("Codec not supported in Parquet: " + codec);
    }

    private static Slice decompressSnappy(Slice input, int uncompressedSize) {
        byte[] buffer = new byte[uncompressedSize];
        ParquetCompressionUtils.decompress((Decompressor)new SnappyDecompressor(), input, 0, input.length(), buffer, 0);
        return Slices.wrappedBuffer(buffer);
    }

    private static Slice decompressGzip(Slice input, int uncompressedSize) throws IOException {
        if (uncompressedSize == 0) {
            return Slices.EMPTY_SLICE;
        }
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(uncompressedSize);
        byte[] buffer = new byte[uncompressedSize];
        try (GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)input.getInput(), 8192);){
            int bytesRead;
            while ((bytesRead = ((InputStream)gzipInputStream).read(buffer)) != -1) {
                sliceOutput.write(buffer, 0, bytesRead);
            }
            Slice slice = sliceOutput.getUnderlyingSlice();
            return slice;
        }
    }

    private static Slice decompressLZO(Slice input, int uncompressedSize) {
        LzoDecompressor lzoDecompressor = new LzoDecompressor();
        long totalDecompressedCount = 0L;
        byte[] output = new byte[uncompressedSize + 8];
        int outputOffset = 0;
        int inputOffset = 0;
        int cumulativeUncompressedBlockLength = 0;
        while (totalDecompressedCount < (long)uncompressedSize) {
            if (totalDecompressedCount == (long)cumulativeUncompressedBlockLength) {
                cumulativeUncompressedBlockLength += Integer.reverseBytes(input.getInt(inputOffset));
                inputOffset += 4;
            }
            int compressedChunkLength = Integer.reverseBytes(input.getInt(inputOffset));
            int decompressionSize = ParquetCompressionUtils.decompress((Decompressor)lzoDecompressor, input, inputOffset += 4, compressedChunkLength, output, outputOffset);
            totalDecompressedCount += (long)decompressionSize;
            outputOffset += decompressionSize;
            inputOffset += compressedChunkLength;
        }
        Preconditions.checkArgument(outputOffset == uncompressedSize);
        return Slices.wrappedBuffer(output, 0, uncompressedSize);
    }

    private static int decompress(Decompressor decompressor, Slice input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        byte[] byteArray = (byte[])input.getBase();
        int byteArrayOffset = inputOffset + (int)(input.getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET);
        int size = decompressor.decompress(byteArray, byteArrayOffset, inputLength, output, outputOffset, output.length - outputOffset);
        return size;
    }
}

