/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.Request;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.Response;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.metrics.RequestMetricCollector;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.util.AWSRequestMetrics;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.util.TimingInfo;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystemStats;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.Duration;

public class PrestoS3FileSystemMetricCollector
extends RequestMetricCollector {
    private final PrestoS3FileSystemStats stats;

    public PrestoS3FileSystemMetricCollector(PrestoS3FileSystemStats stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public void collectMetrics(Request<?> request, Response<?> response) {
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        TimingInfo timingInfo = metrics.getTimingInfo();
        Number requestCounts = timingInfo.getCounter(AWSRequestMetrics.Field.RequestCount.name());
        Number retryCounts = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientRetryCount.name());
        Number throttleExceptions = timingInfo.getCounter(AWSRequestMetrics.Field.ThrottleException.name());
        TimingInfo requestTime = timingInfo.getSubMeasurement(AWSRequestMetrics.Field.HttpRequestTime.name());
        TimingInfo clientExecuteTime = timingInfo.getSubMeasurement(AWSRequestMetrics.Field.ClientExecuteTime.name());
        if (requestCounts != null) {
            this.stats.updateAwsRequestCount(requestCounts.longValue());
        }
        if (retryCounts != null) {
            this.stats.updateAwsRetryCount(retryCounts.longValue());
        }
        if (throttleExceptions != null) {
            this.stats.updateAwsThrottleExceptionsCount(throttleExceptions.longValue());
        }
        if (requestTime != null && requestTime.getTimeTakenMillisIfKnown() != null) {
            this.stats.addAwsRequestTime(new Duration(requestTime.getTimeTakenMillisIfKnown(), TimeUnit.MILLISECONDS));
        }
        if (clientExecuteTime != null && clientExecuteTime.getTimeTakenMillisIfKnown() != null) {
            this.stats.addAwsClientExecuteTime(new Duration(clientExecuteTime.getTimeTakenMillisIfKnown(), TimeUnit.MILLISECONDS));
        }
    }
}

