/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.fs.s3presto.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;

public class LocationHandle {
    private final Path targetPath;
    private final Optional<Path> writePath;
    private final boolean isExistingTable;

    public LocationHandle(Path targetPath, Optional<Path> writePath, boolean isExistingTable) {
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.isExistingTable = isExistingTable;
    }

    @JsonCreator
    public LocationHandle(@JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="writePath") Optional<String> writePath, @JsonProperty(value="isExistingTable") boolean isExistingTable) {
        this.targetPath = new Path(Objects.requireNonNull(targetPath, "targetPath is null"));
        this.writePath = Objects.requireNonNull(writePath, "writePath is null").map(Path::new);
        this.isExistingTable = isExistingTable;
    }

    Path getTargetPath() {
        return this.targetPath;
    }

    Optional<Path> getWritePath() {
        return this.writePath;
    }

    boolean isExistingTable() {
        return this.isExistingTable;
    }

    @JsonProperty(value="targetPath")
    public String getJsonSerializableTargetPath() {
        return this.targetPath.toString();
    }

    @JsonProperty(value="writePath")
    public Optional<String> getJsonSerializableWritePath() {
        return this.writePath.map(Path::toString);
    }

    @JsonProperty(value="isExistingTable")
    public boolean getJsonSerializableIsExistingTable() {
        return this.isExistingTable;
    }
}

