/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HdfsEnvironment;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveErrorCode;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveWriteUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.LocationHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.LocationService;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Partition;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.metastore.Table;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ConnectorSession;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.ErrorCodeSupplier;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.PrestoException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;

public class HiveLocationService
implements LocationService {
    private final HdfsEnvironment hdfsEnvironment;

    @Inject
    public HiveLocationService(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
    }

    @Override
    public LocationHandle forNewTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, String schemaName, String tableName) {
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, schemaName, tableName);
        Path targetPath = HiveWriteUtils.getTableDefaultLocation(context, metastore, this.hdfsEnvironment, schemaName, tableName);
        if (HiveWriteUtils.pathExists(context, this.hdfsEnvironment, targetPath)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for table '%s.%s' already exists: %s", schemaName, tableName, targetPath));
        }
        Path writePath = this.shouldUseTemporaryDirectory(context, targetPath) ? HiveWriteUtils.createTemporaryPath(context, this.hdfsEnvironment, targetPath) : targetPath;
        return new LocationHandle(targetPath, Optional.of(writePath), false);
    }

    @Override
    public LocationHandle forExistingTable(SemiTransactionalHiveMetastore metastore, ConnectorSession session, Table table) {
        Path targetPath;
        HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        Optional<Path> writePath = this.shouldUseTemporaryDirectory(context, targetPath = new Path(table.getStorage().getLocation())) ? Optional.of(HiveWriteUtils.createTemporaryPath(context, this.hdfsEnvironment, targetPath)) : Optional.empty();
        return new LocationHandle(targetPath, writePath, true);
    }

    private boolean shouldUseTemporaryDirectory(HdfsEnvironment.HdfsContext context, Path path) {
        return !HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path);
    }

    @Override
    public Path targetPath(LocationHandle locationHandle, Partition partition, String partitionName) {
        return new Path(partition.getStorage().getLocation());
    }

    @Override
    public Path targetPath(LocationHandle locationHandle, Optional<String> partitionName) {
        if (!partitionName.isPresent()) {
            return locationHandle.getTargetPath();
        }
        return new Path(locationHandle.getTargetPath(), partitionName.get());
    }

    @Override
    public Path targetPathRoot(LocationHandle locationHandle) {
        return locationHandle.getTargetPath();
    }

    @Override
    public Optional<Path> writePath(LocationHandle locationHandle, Optional<String> partitionName) {
        if (!partitionName.isPresent()) {
            return locationHandle.getWritePath();
        }
        return locationHandle.getWritePath().map(path -> new Path((Path)path, (String)partitionName.get()));
    }

    @Override
    public Optional<Path> writePathRoot(LocationHandle locationHandle) {
        return locationHandle.getWritePath();
    }
}

