/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.io.File;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.flink.fs.s3presto.shaded.com.facebook.hive.orc.OrcConf;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveClientConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveCompressionCodec;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveS3Config;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3FileSystem;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3SignerType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.PrestoS3SseType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.util.ConfigurationUtils;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.net.HostAndPort;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.DataSize;
import org.apache.flink.fs.s3presto.shaded.io.airlift.units.Duration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.SequenceFile;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.net.SocksSocketFactory;

public class HdfsConfigurationUpdater {
    private final HostAndPort socksProxy;
    private final Duration ipcPingInterval;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final String domainSocketPath;
    private final Configuration resourcesConfiguration;
    private final HiveCompressionCodec compressionCodec;
    private final int fileSystemMaxCacheSize;
    private final String s3AwsAccessKey;
    private final String s3AwsSecretKey;
    private final String s3Endpoint;
    private final PrestoS3SignerType s3SignerType;
    private final boolean s3UseInstanceCredentials;
    private final boolean s3SslEnabled;
    private final boolean s3SseEnabled;
    private final PrestoS3SseType s3SseType;
    private final String s3EncryptionMaterialsProvider;
    private final String s3KmsKeyId;
    private final String s3SseKmsKeyId;
    private final int s3MaxClientRetries;
    private final int s3MaxErrorRetries;
    private final Duration s3MaxBackoffTime;
    private final Duration s3MaxRetryTime;
    private final Duration s3ConnectTimeout;
    private final Duration s3SocketTimeout;
    private final int s3MaxConnections;
    private final DataSize s3MultipartMinFileSize;
    private final DataSize s3MultipartMinPartSize;
    private final File s3StagingDirectory;
    private final boolean pinS3ClientToCurrentRegion;
    private final String s3UserAgentPrefix;

    @Inject
    public HdfsConfigurationUpdater(HiveClientConfig hiveClientConfig, HiveS3Config s3Config) {
        Objects.requireNonNull(hiveClientConfig, "hiveClientConfig is null");
        Preconditions.checkArgument(hiveClientConfig.getDfsTimeout().toMillis() >= 1L, "dfsTimeout must be at least 1 ms");
        this.socksProxy = hiveClientConfig.getMetastoreSocksProxy();
        this.ipcPingInterval = hiveClientConfig.getIpcPingInterval();
        this.dfsTimeout = hiveClientConfig.getDfsTimeout();
        this.dfsConnectTimeout = hiveClientConfig.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = hiveClientConfig.getDfsConnectMaxRetries();
        this.domainSocketPath = hiveClientConfig.getDomainSocketPath();
        this.resourcesConfiguration = HdfsConfigurationUpdater.readConfiguration(hiveClientConfig.getResourceConfigFiles());
        this.compressionCodec = hiveClientConfig.getHiveCompressionCodec();
        this.fileSystemMaxCacheSize = hiveClientConfig.getFileSystemMaxCacheSize();
        this.s3AwsAccessKey = s3Config.getS3AwsAccessKey();
        this.s3AwsSecretKey = s3Config.getS3AwsSecretKey();
        this.s3Endpoint = s3Config.getS3Endpoint();
        this.s3SignerType = s3Config.getS3SignerType();
        this.s3UseInstanceCredentials = s3Config.isS3UseInstanceCredentials();
        this.s3SslEnabled = s3Config.isS3SslEnabled();
        this.s3SseEnabled = s3Config.isS3SseEnabled();
        this.s3SseType = s3Config.getS3SseType();
        this.s3EncryptionMaterialsProvider = s3Config.getS3EncryptionMaterialsProvider();
        this.s3KmsKeyId = s3Config.getS3KmsKeyId();
        this.s3SseKmsKeyId = s3Config.getS3SseKmsKeyId();
        this.s3MaxClientRetries = s3Config.getS3MaxClientRetries();
        this.s3MaxErrorRetries = s3Config.getS3MaxErrorRetries();
        this.s3MaxBackoffTime = s3Config.getS3MaxBackoffTime();
        this.s3MaxRetryTime = s3Config.getS3MaxRetryTime();
        this.s3ConnectTimeout = s3Config.getS3ConnectTimeout();
        this.s3SocketTimeout = s3Config.getS3SocketTimeout();
        this.s3MaxConnections = s3Config.getS3MaxConnections();
        this.s3MultipartMinFileSize = s3Config.getS3MultipartMinFileSize();
        this.s3MultipartMinPartSize = s3Config.getS3MultipartMinPartSize();
        this.s3StagingDirectory = s3Config.getS3StagingDirectory();
        this.pinS3ClientToCurrentRegion = s3Config.isPinS3ClientToCurrentRegion();
        this.s3UserAgentPrefix = s3Config.getS3UserAgentPrefix();
    }

    private static Configuration readConfiguration(List<String> resourcePaths) {
        Configuration result = new Configuration(false);
        if (resourcePaths == null) {
            return result;
        }
        for (String resourcePath : resourcePaths) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            ConfigurationUtils.copy(resourceProperties, result);
        }
        return result;
    }

    public void updateConfiguration(Configuration config) {
        ConfigurationUtils.copy(this.resourcesConfiguration, config);
        config.setClass("topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", this.domainSocketPath);
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset("dfs.client.read.shortcircuit", true);
        }
        config.setInt("dfs.socket.timeout", Math.toIntExact(this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Math.toIntExact(this.ipcPingInterval.toMillis()));
        config.setInt("ipc.client.connect.timeout", Math.toIntExact(this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        config.set("fs.s3.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3a.impl", PrestoS3FileSystem.class.getName());
        config.set("fs.s3n.impl", PrestoS3FileSystem.class.getName());
        if (this.s3AwsAccessKey != null) {
            config.set("presto.s3.access-key", this.s3AwsAccessKey);
        }
        if (this.s3AwsSecretKey != null) {
            config.set("presto.s3.secret-key", this.s3AwsSecretKey);
        }
        if (this.s3Endpoint != null) {
            config.set("presto.s3.endpoint", this.s3Endpoint);
        }
        if (this.s3SignerType != null) {
            config.set("presto.s3.signer-type", this.s3SignerType.name());
        }
        config.setInt("fs.cache.max-size", this.fileSystemMaxCacheSize);
        HdfsConfigurationUpdater.configureCompression(config, this.compressionCodec);
        config.setBoolean("presto.s3.use-instance-credentials", this.s3UseInstanceCredentials);
        config.setBoolean("presto.s3.ssl.enabled", this.s3SslEnabled);
        config.setBoolean("presto.s3.sse.enabled", this.s3SseEnabled);
        config.set("presto.s3.sse.type", this.s3SseType.name());
        if (this.s3EncryptionMaterialsProvider != null) {
            config.set("presto.s3.encryption-materials-provider", this.s3EncryptionMaterialsProvider);
        }
        if (this.s3KmsKeyId != null) {
            config.set("presto.s3.kms-key-id", this.s3KmsKeyId);
        }
        if (this.s3SseKmsKeyId != null) {
            config.set("presto.s3.sse.kms-key-id", this.s3SseKmsKeyId);
        }
        config.setInt("presto.s3.max-client-retries", this.s3MaxClientRetries);
        config.setInt("presto.s3.max-error-retries", this.s3MaxErrorRetries);
        config.set("presto.s3.max-backoff-time", this.s3MaxBackoffTime.toString());
        config.set("presto.s3.max-retry-time", this.s3MaxRetryTime.toString());
        config.set("presto.s3.connect-timeout", this.s3ConnectTimeout.toString());
        config.set("presto.s3.socket-timeout", this.s3SocketTimeout.toString());
        config.set("presto.s3.staging-directory", this.s3StagingDirectory.toString());
        config.setInt("presto.s3.max-connections", this.s3MaxConnections);
        config.setLong("presto.s3.multipart.min-file-size", this.s3MultipartMinFileSize.toBytes());
        config.setLong("presto.s3.multipart.min-part-size", this.s3MultipartMinPartSize.toBytes());
        config.setBoolean("presto.s3.pin-client-to-current-region", this.pinS3ClientToCurrentRegion);
        config.set("presto.s3.user-agent-prefix", this.s3UserAgentPrefix);
    }

    public static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        config.set(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, compressionCodec.getOrcCompressionKind().name());
        config.set(OrcConf.ConfVars.HIVE_ORC_COMPRESSION.varname, compressionCodec.getOrcCompressionKind().name());
        config.set(OrcFile.OrcTableProperties.COMPRESSION.getPropName(), compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compressionCodec.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compressionCodec.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", compressionCodec.getParquetCompressionCodec().name());
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        @Override
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        @Override
        public void reloadCachedMappings() {
        }

        @Override
        public void reloadCachedMappings(List<String> names) {
        }
    }
}

