/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.datamodeling.StandardBeanProperties;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.KeyType;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.Projection;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.model.ProjectionType;

public final class DynamoDBMapperTableModel<T>
implements DynamoDBTypeConverter<Map<String, AttributeValue>, T> {
    private final Map<String, GlobalSecondaryIndex> globalSecondaryIndexes;
    private final Map<String, LocalSecondaryIndex> localSecondaryIndexes;
    private final Map<String, DynamoDBMapperFieldModel<T, Object>> versions;
    private final Map<String, DynamoDBMapperFieldModel<T, Object>> fields;
    private final Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys;
    private final Properties<T> properties;
    private final Class<T> targetType;

    private DynamoDBMapperTableModel(Builder<T> builder) {
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes();
        this.localSecondaryIndexes = builder.localSecondaryIndexes();
        this.versions = ((Builder)builder).versions();
        this.fields = builder.fields();
        this.keys = builder.keys();
        this.properties = ((Builder)builder).properties;
        this.targetType = ((Builder)builder).targetType;
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> fields() {
        return this.fields.values();
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(String attributeName) {
        DynamoDBMapperFieldModel<T, Object> field = this.fields.get(attributeName);
        if (field == null) {
            throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + attributeName + "]; no mapping for attribute by name");
        }
        return field;
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> keys() {
        return this.keys.values();
    }

    public <H> DynamoDBMapperFieldModel<T, H> hashKey() {
        DynamoDBMapperFieldModel<T, Object> field = this.keys.get((Object)KeyType.HASH);
        if (field == null) {
            throw new DynamoDBMappingException(this.targetType.getSimpleName() + "; no mapping for HASH key");
        }
        return field;
    }

    public <R> DynamoDBMapperFieldModel<T, R> rangeKey() {
        DynamoDBMapperFieldModel<T, Object> field = this.keys.get((Object)KeyType.RANGE);
        if (field == null) {
            throw new DynamoDBMappingException(this.targetType.getSimpleName() + "; no mapping for RANGE key");
        }
        return field;
    }

    public <R> DynamoDBMapperFieldModel<T, R> rangeKeyIfExists() {
        return this.keys.get((Object)KeyType.RANGE);
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> versions() {
        return this.versions.values();
    }

    public boolean versioned() {
        return !this.versions.isEmpty();
    }

    public Collection<GlobalSecondaryIndex> globalSecondaryIndexes() {
        if (this.globalSecondaryIndexes.isEmpty()) {
            return null;
        }
        ArrayList<GlobalSecondaryIndex> copies = new ArrayList<GlobalSecondaryIndex>(this.globalSecondaryIndexes.size());
        for (String indexName : this.globalSecondaryIndexes.keySet()) {
            copies.add(this.globalSecondaryIndex(indexName));
        }
        return copies;
    }

    public GlobalSecondaryIndex globalSecondaryIndex(String indexName) {
        if (!this.globalSecondaryIndexes.containsKey(indexName)) {
            return null;
        }
        GlobalSecondaryIndex gsi = this.globalSecondaryIndexes.get(indexName);
        GlobalSecondaryIndex copy = new GlobalSecondaryIndex().withIndexName(gsi.getIndexName());
        copy.withProjection(new Projection().withProjectionType(gsi.getProjection().getProjectionType()));
        for (KeySchemaElement key : gsi.getKeySchema()) {
            copy.withKeySchema(new KeySchemaElement(key.getAttributeName(), key.getKeyType()));
        }
        return copy;
    }

    public Collection<LocalSecondaryIndex> localSecondaryIndexes() {
        if (this.localSecondaryIndexes.isEmpty()) {
            return null;
        }
        ArrayList<LocalSecondaryIndex> copies = new ArrayList<LocalSecondaryIndex>(this.localSecondaryIndexes.size());
        for (String indexName : this.localSecondaryIndexes.keySet()) {
            copies.add(this.localSecondaryIndex(indexName));
        }
        return copies;
    }

    public LocalSecondaryIndex localSecondaryIndex(String indexName) {
        if (!this.localSecondaryIndexes.containsKey(indexName)) {
            return null;
        }
        LocalSecondaryIndex lsi = this.localSecondaryIndexes.get(indexName);
        LocalSecondaryIndex copy = new LocalSecondaryIndex().withIndexName(lsi.getIndexName());
        copy.withProjection(new Projection().withProjectionType(lsi.getProjection().getProjectionType()));
        for (KeySchemaElement key : lsi.getKeySchema()) {
            copy.withKeySchema(new KeySchemaElement(key.getAttributeName(), key.getKeyType()));
        }
        return copy;
    }

    @Override
    public Map<String, AttributeValue> convert(T object) {
        LinkedHashMap<String, AttributeValue> map = new LinkedHashMap<String, AttributeValue>();
        for (DynamoDBMapperFieldModel<T, Object> field : this.fields()) {
            try {
                AttributeValue value = field.getAndConvert(object);
                if (value == null) continue;
                map.put(field.name(), value);
            }
            catch (RuntimeException e) {
                throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; could not convert attribute", e);
            }
        }
        return map;
    }

    @Override
    public T unconvert(Map<String, AttributeValue> object) {
        T result = StandardBeanProperties.DeclaringReflect.newInstance(this.targetType);
        if (!object.isEmpty()) {
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields()) {
                try {
                    AttributeValue value = object.get(field.name());
                    if (value == null) continue;
                    field.unconvertAndSet(result, value);
                }
                catch (RuntimeException e) {
                    throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; could not unconvert attribute", e);
                }
            }
        }
        return result;
    }

    public <H, R> T createKey(H hashKey, R rangeKey) {
        T key = StandardBeanProperties.DeclaringReflect.newInstance(this.targetType);
        if (hashKey != null) {
            DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
            hk.set(key, hashKey);
        }
        if (rangeKey != null) {
            DynamoDBMapperFieldModel<T, R> rk = this.rangeKey();
            rk.set(key, rangeKey);
        }
        return key;
    }

    public <H, R> Map<String, AttributeValue> convertKey(T key) {
        DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
        DynamoDBMapperFieldModel<T, R> rk = this.rangeKeyIfExists();
        return this.convertKey(hk.get(key), rk == null ? null : (R)rk.get(key));
    }

    public <H, R> Map<String, AttributeValue> convertKey(H hashKey, R rangeKey) {
        Object rkValue;
        Object hkValue;
        LinkedHashMap<String, AttributeValue> key = new LinkedHashMap<String, AttributeValue>(4);
        DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
        Object object = hkValue = hashKey == null ? null : hk.convert((Object)hashKey);
        if (hkValue == null) {
            throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + hk.name() + "]; no HASH key value present");
        }
        key.put(hk.name(), (AttributeValue)hkValue);
        DynamoDBMapperFieldModel<T, R> rk = this.rangeKeyIfExists();
        Object object2 = rkValue = rangeKey == null ? null : rk.convert((Object)rangeKey);
        if (rkValue != null) {
            key.put(rk.name(), (AttributeValue)rkValue);
        } else if (rk != null) {
            throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + rk.name() + "]; no RANGE key value present");
        }
        return key;
    }

    static interface Properties<T> {
        public String tableName();

        public static final class Immutable<T>
        implements Properties<T> {
            private final String tableName;

            public Immutable(Properties<T> properties) {
                this.tableName = properties.tableName();
            }

            @Override
            public String tableName() {
                return this.tableName;
            }
        }
    }

    static class Builder<T> {
        private final Map<String, DynamoDBMapperFieldModel<T, Object>> versions = new LinkedHashMap<String, DynamoDBMapperFieldModel<T, Object>>(4);
        private final Map<String, DynamoDBMapperFieldModel<T, Object>> fields = new LinkedHashMap<String, DynamoDBMapperFieldModel<T, Object>>();
        private final Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys = new EnumMap<KeyType, DynamoDBMapperFieldModel<T, Object>>(KeyType.class);
        private final Properties properties;
        private final Class<T> targetType;

        public Builder(Class<T> targetType, Properties<T> properties) {
            this.properties = properties;
            this.targetType = targetType;
        }

        public Builder<T> with(DynamoDBMapperFieldModel<T, Object> field) {
            this.fields.put(field.name(), field);
            if (field.keyType() != null) {
                this.keys.put(field.keyType(), field);
            }
            if (field.versioned()) {
                this.versions.put(field.name(), field);
            }
            return this;
        }

        public Map<String, GlobalSecondaryIndex> globalSecondaryIndexes() {
            GlobalSecondaryIndex gsi;
            LinkedHashMap<String, GlobalSecondaryIndex> map = new LinkedHashMap<String, GlobalSecondaryIndex>();
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.HASH)) {
                    if (map.put(indexName, gsi = new GlobalSecondaryIndex().withIndexName(indexName)) != null) {
                        throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; must not duplicate GSI " + indexName);
                    }
                    gsi.withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                    gsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.HASH));
                }
            }
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.RANGE)) {
                    gsi = (GlobalSecondaryIndex)map.get(indexName);
                    if (gsi == null) {
                        throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; no HASH key for GSI " + indexName);
                    }
                    gsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.RANGE));
                }
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(map);
        }

        public Map<String, LocalSecondaryIndex> localSecondaryIndexes() {
            LinkedHashMap<String, LocalSecondaryIndex> map = new LinkedHashMap<String, LocalSecondaryIndex>();
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.localSecondaryIndexNames()) {
                    LocalSecondaryIndex lsi;
                    if (map.put(indexName, lsi = new LocalSecondaryIndex().withIndexName(indexName)) != null) {
                        throw new DynamoDBMappingException(this.targetType.getSimpleName() + "[" + field.name() + "]; must not duplicate LSI " + indexName);
                    }
                    lsi.withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                    lsi.withKeySchema(new KeySchemaElement(this.keys.get((Object)KeyType.HASH).name(), KeyType.HASH));
                    lsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.RANGE));
                }
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(map);
        }

        private Map<String, DynamoDBMapperFieldModel<T, Object>> versions() {
            if (this.versions.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.versions);
        }

        public Map<String, DynamoDBMapperFieldModel<T, Object>> fields() {
            if (this.fields.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.fields);
        }

        public Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys() {
            if (this.keys.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(this.keys);
        }

        public DynamoDBMapperTableModel<T> build() {
            DynamoDBMapperTableModel result = new DynamoDBMapperTableModel(this);
            if (this.properties.tableName() != null) {
                result.hashKey();
            }
            return result;
        }
    }
}

