/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.s3a;

import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.ListObjectsV2Request;

public class S3ListRequest {
    private ListObjectsRequest v1Request;
    private ListObjectsV2Request v2Request;

    protected S3ListRequest(ListObjectsRequest v1, ListObjectsV2Request v2) {
        this.v1Request = v1;
        this.v2Request = v2;
    }

    public static S3ListRequest v1(ListObjectsRequest request) {
        return new S3ListRequest(request, null);
    }

    public static S3ListRequest v2(ListObjectsV2Request request) {
        return new S3ListRequest(null, request);
    }

    public boolean isV1() {
        return this.v1Request != null;
    }

    public ListObjectsRequest getV1() {
        return this.v1Request;
    }

    public ListObjectsV2Request getV2() {
        return this.v2Request;
    }

    public String toString() {
        if (this.isV1()) {
            return String.format("List %s:/%s", this.v1Request.getBucketName(), this.v1Request.getPrefix());
        }
        return String.format("List %s:/%s", this.v2Request.getBucketName(), this.v2Request.getPrefix());
    }
}

