/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.io.airlift.configuration;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.MoreObjects;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Key;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigDefaults;

class ConfigDefaultsHolder<T>
implements Comparable<ConfigDefaultsHolder<T>> {
    private static final AtomicLong NEXT_PRIORITY = new AtomicLong();
    private final Key<T> configKey;
    private final ConfigDefaults<T> configDefaults;
    private final long priority = NEXT_PRIORITY.getAndIncrement();

    ConfigDefaultsHolder(Key<T> configKey, ConfigDefaults<T> configDefaults) {
        this.configKey = Objects.requireNonNull(configKey, "configKey is null");
        this.configDefaults = Objects.requireNonNull(configDefaults, "configDefaults is null");
    }

    public Key<T> getConfigKey() {
        return this.configKey;
    }

    public ConfigDefaults<T> getConfigDefaults() {
        return this.configDefaults;
    }

    @Override
    public int compareTo(ConfigDefaultsHolder<T> o) {
        return Long.compare(this.priority, o.priority);
    }

    public int hashCode() {
        return Objects.hash(this.configDefaults, this.priority);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigDefaultsHolder other = (ConfigDefaultsHolder)obj;
        return Objects.equals(this.configDefaults, other.configDefaults) && Objects.equals(this.priority, other.priority);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("configKey", this.configKey).add("configDefaults", this.configDefaults).add("priority", this.priority).toString();
    }
}

