/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.security;

import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.security.LegacySecurityModule;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.security.SecurityConfig;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.security.SqlStandardSecurityModule;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.plugin.base.security.FileBasedAccessControlModule;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.plugin.base.security.ReadOnlySecurityModule;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Binder;
import org.apache.flink.fs.s3presto.shaded.com.google.inject.Module;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.AbstractConfigurationAwareModule;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConditionalModule;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    @Override
    protected void setup(Binder binder) {
        this.bindSecurityModule("legacy", new LegacySecurityModule());
        this.bindSecurityModule("file", (Module)new FileBasedAccessControlModule());
        this.bindSecurityModule("read-only", (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule("sql-standard", new SqlStandardSecurityModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), module));
    }
}

