/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.rcfile;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.FileFormatDataSourceStats;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.rcfile.RcFileDataSource;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Preconditions;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;

public class HdfsRcFileDataSource
implements RcFileDataSource {
    private final FSDataInputStream inputStream;
    private final String path;
    private final long size;
    private final FileFormatDataSourceStats stats;
    private long readTimeNanos;
    private long readBytes;

    public HdfsRcFileDataSource(String path, FSDataInputStream inputStream, long size, FileFormatDataSourceStats stats) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
        this.size = size;
        Preconditions.checkArgument(size >= 0L, "size is negative");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public long getReadBytes() {
        return this.readBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getSize() {
        return this.size;
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        long readDuration = System.nanoTime() - start;
        this.stats.readDataBytesPerSecond(bufferLength, readDuration);
        this.readTimeNanos += readDuration;
        this.readBytes += (long)bufferLength;
    }

    public String toString() {
        return this.path;
    }
}

