/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.HiveColumnHandle;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetCompressionUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDataSource;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetEncoding;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.ParquetTypeUtils;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.RichColumnDescriptor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate.ParquetDictionaryDescriptor;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate.ParquetIntegerStatistics;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive.parquet.predicate.TupleDomainParquetPredicate;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.predicate.TupleDomain;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.IntegerType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.SmallintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.TinyintType;
import org.apache.flink.fs.s3presto.shaded.com.facebook.presto.spi.type.Type;
import org.apache.flink.fs.s3presto.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Verify;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Sets;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slice;
import org.apache.flink.fs.s3presto.shaded.io.airlift.slice.Slices;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.column.statistics.Statistics;
import parquet.format.DictionaryPageHeader;
import parquet.format.PageHeader;
import parquet.format.PageType;
import parquet.format.Util;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;

public final class ParquetPredicateUtils {
    private ParquetPredicateUtils() {
    }

    public static boolean isStatisticsOverflow(Type type, ParquetIntegerStatistics parquetIntegerStatistics) {
        long min = parquetIntegerStatistics.getMin();
        long max = parquetIntegerStatistics.getMax();
        return type.equals(TinyintType.TINYINT) && (min < -128L || max > 127L) || type.equals(SmallintType.SMALLINT) && (min < -32768L || max > 32767L) || type.equals(IntegerType.INTEGER) && (min < Integer.MIN_VALUE || max > Integer.MAX_VALUE);
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(MessageType fileSchema, MessageType requestedSchema, TupleDomain<HiveColumnHandle> effectivePredicate) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            Optional<RichColumnDescriptor> descriptor = ParquetTypeUtils.getDescriptor(fileSchema, requestedSchema, ImmutableList.of(((HiveColumnHandle)entry.getKey()).getName()));
            if (!descriptor.isPresent()) continue;
            predicate.put(descriptor.get(), entry.getValue());
        }
        return TupleDomain.withColumnDomains(predicate.build());
    }

    public static ParquetPredicate buildParquetPredicate(MessageType requestedSchema, TupleDomain<ColumnDescriptor> parquetTupleDomain, MessageType fileSchema) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (String[] paths : requestedSchema.getPaths()) {
            Optional<RichColumnDescriptor> descriptor = ParquetTypeUtils.getDescriptor(fileSchema, requestedSchema, Arrays.asList(paths));
            if (!descriptor.isPresent()) continue;
            columnReferences.add((Object)descriptor.get());
        }
        return new TupleDomainParquetPredicate(parquetTupleDomain, (List<RichColumnDescriptor>)((Object)columnReferences.build()));
    }

    public static boolean predicateMatches(ParquetPredicate parquetPredicate, BlockMetaData block, ParquetDataSource dataSource, MessageType fileSchema, MessageType requestedSchema, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        Map<ColumnDescriptor, Statistics<?>> columnStatistics = ParquetPredicateUtils.getStatistics(block, fileSchema, requestedSchema);
        if (!parquetPredicate.matches(block.getRowCount(), columnStatistics)) {
            return false;
        }
        Map<ColumnDescriptor, ParquetDictionaryDescriptor> dictionaries = ParquetPredicateUtils.getDictionaries(block, dataSource, fileSchema, requestedSchema, parquetTupleDomain);
        return parquetPredicate.matches(dictionaries);
    }

    private static Map<ColumnDescriptor, Statistics<?>> getStatistics(BlockMetaData blockMetadata, MessageType fileSchema, MessageType requestedSchema) {
        ImmutableMap.Builder<RichColumnDescriptor, Statistics> statistics = ImmutableMap.builder();
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            Optional<RichColumnDescriptor> descriptor;
            Statistics columnStatistics = columnMetaData.getStatistics();
            if (columnStatistics == null || !(descriptor = ParquetTypeUtils.getDescriptor(fileSchema, requestedSchema, Arrays.asList(columnMetaData.getPath().toArray()))).isPresent()) continue;
            statistics.put(descriptor.get(), columnStatistics);
        }
        return statistics.build();
    }

    private static Map<ColumnDescriptor, ParquetDictionaryDescriptor> getDictionaries(BlockMetaData blockMetadata, ParquetDataSource dataSource, MessageType fileSchema, MessageType requestedSchema, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        ImmutableMap.Builder<ColumnDescriptor, ParquetDictionaryDescriptor> dictionaries = ImmutableMap.builder();
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            Optional<RichColumnDescriptor> descriptor = ParquetTypeUtils.getDescriptor(fileSchema, requestedSchema, Arrays.asList(columnMetaData.getPath().toArray()));
            if (!descriptor.isPresent()) continue;
            ColumnDescriptor columnDescriptor = descriptor.get();
            if (!ParquetPredicateUtils.isOnlyDictionaryEncodingPages(columnMetaData.getEncodings()) || !ParquetPredicateUtils.isColumnPredicate(columnDescriptor, parquetTupleDomain)) continue;
            try {
                int totalSize = Math.toIntExact(columnMetaData.getTotalSize());
                byte[] buffer = new byte[totalSize];
                dataSource.readFully(columnMetaData.getStartingPos(), buffer);
                Optional<ParquetDictionaryPage> dictionaryPage = ParquetPredicateUtils.readDictionaryPage(buffer, columnMetaData.getCodec());
                dictionaries.put(columnDescriptor, new ParquetDictionaryDescriptor(columnDescriptor, dictionaryPage));
            }
            catch (IOException iOException) {}
            break;
        }
        return dictionaries.build();
    }

    private static Optional<ParquetDictionaryPage> readDictionaryPage(byte[] data, CompressionCodecName codecName) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            PageHeader pageHeader = Util.readPageHeader((InputStream)inputStream);
            if (pageHeader.type != PageType.DICTIONARY_PAGE) {
                return Optional.empty();
            }
            Slice compressedData = Slices.wrappedBuffer(data, data.length - inputStream.available(), pageHeader.getCompressed_page_size());
            DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
            ParquetEncoding encoding = ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dicHeader.getEncoding().name()));
            int dictionarySize = dicHeader.getNum_values();
            return Optional.of(new ParquetDictionaryPage(ParquetCompressionUtils.decompress(codecName, compressedData, pageHeader.getUncompressed_page_size()), dictionarySize, encoding));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    private static boolean isColumnPredicate(ColumnDescriptor columnDescriptor, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        Verify.verify(parquetTupleDomain.getDomains().isPresent(), "parquetTupleDomain is empty", new Object[0]);
        return ((Map)parquetTupleDomain.getDomains().get()).keySet().contains(columnDescriptor);
    }

    @VisibleForTesting
    static boolean isOnlyDictionaryEncodingPages(Set<Encoding> encodings) {
        if (encodings.contains(Encoding.PLAIN_DICTIONARY)) {
            return Sets.difference(encodings, ImmutableSet.of(Encoding.PLAIN_DICTIONARY, Encoding.RLE, Encoding.BIT_PACKED)).isEmpty();
        }
        return false;
    }
}

