/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.com.facebook.presto.hive;

import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.flink.fs.s3presto.shaded.com.google.common.base.Splitter;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.fs.s3presto.shaded.com.google.common.collect.Iterables;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.Config;
import org.apache.flink.fs.s3presto.shaded.io.airlift.configuration.ConfigDescription;

public class StaticMetastoreConfig {
    private static final Splitter SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private List<URI> metastoreUris;

    @NotNull
    public List<URI> getMetastoreUris() {
        return this.metastoreUris;
    }

    @Config(value="hive.metastore.uri")
    @ConfigDescription(value="Hive metastore URIs (comma separated)")
    public StaticMetastoreConfig setMetastoreUris(String uris) {
        if (uris == null) {
            this.metastoreUris = null;
            return this;
        }
        this.metastoreUris = ImmutableList.copyOf(Iterables.transform(SPLITTER.split(uris), URI::create));
        return this;
    }
}

