/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.spec;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.dynamodbv2.document.spec.AbstractSpec;

public class AbstractSpecWithPrimaryKey<T extends AmazonWebServiceRequest>
extends AbstractSpec<T> {
    private Collection<KeyAttribute> keyComponents;

    protected AbstractSpecWithPrimaryKey(T request) {
        super(request);
    }

    public final Collection<KeyAttribute> getKeyComponents() {
        return this.keyComponents;
    }

    public AbstractSpecWithPrimaryKey<T> withPrimaryKey(KeyAttribute ... components) {
        this.keyComponents = components == null ? null : Arrays.asList(components);
        return this;
    }

    public AbstractSpecWithPrimaryKey<T> withPrimaryKey(PrimaryKey primaryKey) {
        this.keyComponents = primaryKey == null ? null : primaryKey.getComponents();
        return this;
    }

    public AbstractSpecWithPrimaryKey<T> withPrimaryKey(String hashKeyName, Object hashKeyValue) {
        if (hashKeyName == null) {
            throw new IllegalArgumentException();
        }
        this.withPrimaryKey(new PrimaryKey(hashKeyName, hashKeyValue));
        return this;
    }

    public AbstractSpecWithPrimaryKey<T> withPrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        if (hashKeyName == null) {
            throw new IllegalArgumentException("Invalid hash key name");
        }
        if (rangeKeyName == null) {
            throw new IllegalArgumentException("Invalid range key name");
        }
        if (hashKeyName.equals(rangeKeyName)) {
            throw new IllegalArgumentException("Names of hash and range keys must not be the same");
        }
        this.withPrimaryKey(new PrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue));
        return this;
    }
}

