/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.json.internal;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.json.internal.JsonMarshaller;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.json.internal.JsonMarshallerContext;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.protocol.json.internal.ValueToStringConverters;

@SdkInternalApi
public class QueryParamMarshallers {
    public static final JsonMarshaller<String> STRING = new SimpleQueryParamMarshaller<String>(ValueToStringConverters.FROM_STRING);
    public static final JsonMarshaller<Integer> INTEGER = new SimpleQueryParamMarshaller<Integer>(ValueToStringConverters.FROM_INTEGER);
    public static final JsonMarshaller<Long> LONG = new SimpleQueryParamMarshaller<Long>(ValueToStringConverters.FROM_LONG);
    public static final JsonMarshaller<Double> DOUBLE = new SimpleQueryParamMarshaller<Double>(ValueToStringConverters.FROM_DOUBLE);
    public static final JsonMarshaller<Float> FLOAT = new SimpleQueryParamMarshaller<Float>(ValueToStringConverters.FROM_FLOAT);
    public static final JsonMarshaller<Boolean> BOOLEAN = new SimpleQueryParamMarshaller<Boolean>(ValueToStringConverters.FROM_BOOLEAN);
    public static final JsonMarshaller<Date> DATE = new SimpleQueryParamMarshaller<Date>(ValueToStringConverters.FROM_DATE);
    public static final JsonMarshaller<List> LIST = new JsonMarshaller<List>(){

        @Override
        public void marshall(List list, JsonMarshallerContext context, String paramName) {
            for (Object listVal : list) {
                context.marshall(MarshallLocation.QUERY_PARAM, listVal, paramName);
            }
        }
    };
    public static final JsonMarshaller<Map> MAP = new JsonMarshaller<Map>(){

        @Override
        public void marshall(Map val, JsonMarshallerContext context, String paramName) {
            for (Map.Entry mapEntry : val.entrySet()) {
                context.marshall(MarshallLocation.QUERY_PARAM, mapEntry.getValue(), (String)mapEntry.getKey());
            }
        }
    };

    private static class SimpleQueryParamMarshaller<T>
    implements JsonMarshaller<T> {
        private final ValueToStringConverters.ValueToString<T> converter;

        private SimpleQueryParamMarshaller(ValueToStringConverters.ValueToString<T> converter) {
            this.converter = converter;
        }

        @Override
        public void marshall(T val, JsonMarshallerContext context, String paramName) {
            context.request().addParameter(paramName, this.converter.convert(val));
        }
    }
}

