/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.fs.s3.common.hadoop.HadoopFileSystem;
import org.apache.flink.fs.s3.common.utils.BackPressuringExecutor;
import org.apache.flink.fs.s3.common.utils.OffsetAwareOutputStream;
import org.apache.flink.fs.s3.common.utils.RefCountedFile;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUpload;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUploadImpl;
import org.apache.flink.fs.s3.common.writer.S3MultiPartUploader;
import org.apache.flink.fs.s3.common.writer.S3Recoverable;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@Internal
final class S3RecoverableMultipartUploadFactory {
    private final FileSystem fs;
    private final S3MultiPartUploader twoPhaseUploader;
    private final FunctionWithException<File, RefCountedFile, IOException> tmpFileSupplier;
    private final int maxConcurrentUploadsPerStream;
    private final Executor executor;

    S3RecoverableMultipartUploadFactory(FileSystem fs, S3MultiPartUploader twoPhaseUploader, int maxConcurrentUploadsPerStream, Executor executor, FunctionWithException<File, RefCountedFile, IOException> tmpFileSupplier) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        this.maxConcurrentUploadsPerStream = maxConcurrentUploadsPerStream;
        this.executor = executor;
        this.twoPhaseUploader = twoPhaseUploader;
        this.tmpFileSupplier = tmpFileSupplier;
    }

    RecoverableMultiPartUpload getNewRecoverableUpload(Path path) throws IOException {
        return RecoverableMultiPartUploadImpl.newUpload(this.twoPhaseUploader, this.limitedExecutor(), this.pathToObjectName(path));
    }

    RecoverableMultiPartUpload recoverRecoverableUpload(S3Recoverable recoverable) throws IOException {
        Optional<File> incompletePart = this.downloadLastDataChunk(recoverable);
        return RecoverableMultiPartUploadImpl.recoverUpload(this.twoPhaseUploader, this.limitedExecutor(), recoverable.uploadId(), recoverable.getObjectName(), recoverable.parts(), recoverable.numBytesInParts(), incompletePart);
    }

    @VisibleForTesting
    Optional<File> downloadLastDataChunk(S3Recoverable recoverable) throws IOException {
        String objectName = recoverable.incompleteObjectName();
        if (objectName == null) {
            return Optional.empty();
        }
        RefCountedFile fileAndStream = (RefCountedFile)this.tmpFileSupplier.apply(null);
        File file = fileAndStream.getFile();
        long numBytes = 0L;
        try (OffsetAwareOutputStream outStream = fileAndStream.getStream();
             FSDataInputStream inStream = this.fs.open(new org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path('/' + objectName));){
            int numRead;
            byte[] buffer = new byte[32768];
            while ((numRead = inStream.read(buffer)) > 0) {
                outStream.write(buffer, 0, numRead);
                numBytes += (long)numRead;
            }
        }
        if (numBytes != file.length() || numBytes != fileAndStream.getStream().getLength()) {
            throw new IOException(String.format("Error recovering writer: Downloading the last data chunk file gives incorrect length. File=%d bytes, Stream=%d bytes", file.length(), numBytes));
        }
        if (numBytes != recoverable.incompleteObjectLength()) {
            throw new IOException(String.format("Error recovering writer: Downloading the last data chunk file gives incorrect length.File length is %d bytes, RecoveryData indicates %d bytes", numBytes, recoverable.incompleteObjectLength()));
        }
        return Optional.of(file);
    }

    @VisibleForTesting
    String pathToObjectName(Path path) {
        org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path hadoopPath = HadoopFileSystem.toHadoopPath(path);
        if (!hadoopPath.isAbsolute()) {
            hadoopPath = new org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path(this.fs.getWorkingDirectory(), hadoopPath);
        }
        return hadoopPath.toUri().getScheme() != null && hadoopPath.toUri().getPath().isEmpty() ? "" : hadoopPath.toUri().getPath().substring(1);
    }

    private Executor limitedExecutor() {
        return this.maxConcurrentUploadsPerStream <= 0 ? this.executor : new BackPressuringExecutor(this.executor, this.maxConcurrentUploadsPerStream);
    }
}

