/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.fs.s3.common.utils.RefCountedFSOutputStream;
import org.apache.flink.fs.s3.common.writer.MultiPartUploadInfo;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUpload;
import org.apache.flink.fs.s3.common.writer.S3Committer;
import org.apache.flink.fs.s3.common.writer.S3MultiPartUploader;
import org.apache.flink.fs.s3.common.writer.S3Recoverable;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.PartETag;
import org.apache.flink.fs.s3base.shaded.com.amazonaws.services.s3.model.UploadPartResult;
import org.apache.flink.util.Preconditions;

@Internal
@NotThreadSafe
final class RecoverableMultiPartUploadImpl
implements RecoverableMultiPartUpload {
    private final S3MultiPartUploader s3MPUploader;
    private final Executor uploadThreadPool;
    private final Deque<CompletableFuture<PartETag>> uploadsInProgress;
    private final String namePrefixForTempObjects;
    private final MultiPartUploadInfo currentUploadInfo;

    private RecoverableMultiPartUploadImpl(S3MultiPartUploader s3uploader, Executor uploadThreadPool, String uploadId, String objectName, List<PartETag> partsSoFar, long numBytes, Optional<File> incompletePart) {
        Preconditions.checkArgument((numBytes >= 0L ? 1 : 0) != 0);
        this.s3MPUploader = (S3MultiPartUploader)Preconditions.checkNotNull((Object)s3uploader);
        this.uploadThreadPool = (Executor)Preconditions.checkNotNull((Object)uploadThreadPool);
        this.currentUploadInfo = new MultiPartUploadInfo(objectName, uploadId, partsSoFar, numBytes, incompletePart);
        this.namePrefixForTempObjects = RecoverableMultiPartUploadImpl.incompleteObjectNamePrefix(objectName);
        this.uploadsInProgress = new ArrayDeque<CompletableFuture<PartETag>>();
    }

    @Override
    public void uploadPart(RefCountedFSOutputStream file) throws IOException {
        Preconditions.checkState((boolean)file.isClosed());
        CompletableFuture<PartETag> future = new CompletableFuture<PartETag>();
        this.uploadsInProgress.add(future);
        long partLength = file.getPos();
        this.currentUploadInfo.registerNewPart(partLength);
        file.retain();
        this.uploadThreadPool.execute(new UploadTask(this.s3MPUploader, this.currentUploadInfo, file, future));
    }

    @Override
    public Optional<File> getIncompletePart() {
        return this.currentUploadInfo.getIncompletePart();
    }

    @Override
    public S3Committer snapshotAndGetCommitter() throws IOException {
        S3Recoverable snapshot = this.snapshotAndGetRecoverable(null);
        return new S3Committer(this.s3MPUploader, snapshot.getObjectName(), snapshot.uploadId(), snapshot.parts(), snapshot.numBytesInParts());
    }

    @Override
    public S3Recoverable snapshotAndGetRecoverable(@Nullable RefCountedFSOutputStream incompletePartFile) throws IOException {
        String incompletePartObjectName = this.safelyUploadSmallPart(incompletePartFile);
        this.awaitPendingPartsUpload();
        String objectName = this.currentUploadInfo.getObjectName();
        String uploadId = this.currentUploadInfo.getUploadId();
        List<PartETag> completedParts = this.currentUploadInfo.getCopyOfEtagsOfCompleteParts();
        long sizeInBytes = this.currentUploadInfo.getExpectedSizeInBytes();
        if (incompletePartObjectName == null) {
            return new S3Recoverable(objectName, uploadId, completedParts, sizeInBytes);
        }
        return new S3Recoverable(objectName, uploadId, completedParts, sizeInBytes, incompletePartObjectName, incompletePartFile.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String safelyUploadSmallPart(@Nullable RefCountedFSOutputStream file) throws IOException {
        if (file == null || file.getPos() == 0L) {
            return null;
        }
        String incompletePartObjectName = this.createTmpObjectName();
        file.retain();
        try (InputStream inputStream = file.getInputStream();){
            this.s3MPUploader.uploadIncompletePart(incompletePartObjectName, inputStream, file.getPos());
        }
        finally {
            file.release();
        }
        return incompletePartObjectName;
    }

    @VisibleForTesting
    static String incompleteObjectNamePrefix(String objectName) {
        String child;
        String parent;
        Preconditions.checkNotNull((Object)objectName);
        int lastSlash = objectName.lastIndexOf(47);
        if (lastSlash == -1) {
            parent = "";
            child = objectName;
        } else {
            parent = objectName.substring(0, lastSlash + 1);
            child = objectName.substring(lastSlash + 1);
        }
        return parent + (child.isEmpty() ? "" : Character.valueOf('_')) + child + "_tmp_";
    }

    private void awaitPendingPartsUpload() throws IOException {
        Preconditions.checkState((this.currentUploadInfo.getRemainingParts() == this.uploadsInProgress.size() ? 1 : 0) != 0);
        while (this.currentUploadInfo.getRemainingParts() > 0) {
            CompletableFuture<PartETag> next = this.uploadsInProgress.peekFirst();
            PartETag nextPart = this.awaitPendingPartUploadToComplete(next);
            this.currentUploadInfo.registerCompletePart(nextPart);
            this.uploadsInProgress.removeFirst();
        }
    }

    private PartETag awaitPendingPartUploadToComplete(CompletableFuture<PartETag> upload) throws IOException {
        PartETag completedUploadEtag;
        try {
            completedUploadEtag = upload.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for part uploads to complete");
        }
        catch (ExecutionException e) {
            throw new IOException("Uploading parts failed", e.getCause());
        }
        return completedUploadEtag;
    }

    private String createTmpObjectName() {
        return this.namePrefixForTempObjects + UUID.randomUUID().toString();
    }

    public static RecoverableMultiPartUploadImpl newUpload(S3MultiPartUploader s3uploader, Executor uploadThreadPool, String objectName) throws IOException {
        String multiPartUploadId = s3uploader.startMultiPartUpload(objectName);
        return new RecoverableMultiPartUploadImpl(s3uploader, uploadThreadPool, multiPartUploadId, objectName, new ArrayList<PartETag>(), 0L, Optional.empty());
    }

    public static RecoverableMultiPartUploadImpl recoverUpload(S3MultiPartUploader s3uploader, Executor uploadThreadPool, String multipartUploadId, String objectName, List<PartETag> partsSoFar, long numBytesSoFar, Optional<File> incompletePart) {
        return new RecoverableMultiPartUploadImpl(s3uploader, uploadThreadPool, multipartUploadId, objectName, new ArrayList<PartETag>(partsSoFar), numBytesSoFar, incompletePart);
    }

    private static class UploadTask
    implements Runnable {
        private final S3MultiPartUploader s3uploader;
        private final String objectName;
        private final String uploadId;
        private final int partNumber;
        private final RefCountedFSOutputStream file;
        private final CompletableFuture<PartETag> future;

        UploadTask(S3MultiPartUploader s3uploader, MultiPartUploadInfo currentUpload, RefCountedFSOutputStream file, CompletableFuture<PartETag> future) {
            Preconditions.checkNotNull((Object)currentUpload);
            this.objectName = currentUpload.getObjectName();
            this.uploadId = currentUpload.getUploadId();
            this.partNumber = currentUpload.getNumberOfRegisteredParts();
            Preconditions.checkArgument((this.partNumber >= 1 && this.partNumber <= 10000 ? 1 : 0) != 0);
            this.s3uploader = (S3MultiPartUploader)Preconditions.checkNotNull((Object)s3uploader);
            this.file = (RefCountedFSOutputStream)Preconditions.checkNotNull((Object)file);
            this.future = (CompletableFuture)Preconditions.checkNotNull(future);
        }

        @Override
        public void run() {
            try (InputStream inputStream = this.file.getInputStream();){
                UploadPartResult result = this.s3uploader.uploadPart(this.objectName, this.uploadId, this.partNumber, inputStream, this.file.getPos());
                this.future.complete(new PartETag(result.getPartNumber(), result.getETag()));
                this.file.release();
            }
            catch (Throwable t) {
                this.future.completeExceptionally(t);
            }
        }
    }
}

