/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.BeanProperty;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.JavaType;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.jsonschema.SchemaAware;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.ser.ContextualSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.ser.ResolvableSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.fs.s3presto.shaded.org.apache.htrace.fasterxml.jackson.databind.util.Converter;

public class StdDelegatingSerializer
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable,
SchemaAware {
    protected final Converter<Object, ?> _converter;
    protected final JavaType _delegateType;
    protected final JsonSerializer<Object> _delegateSerializer;

    public StdDelegatingSerializer(Converter<?, ?> converter) {
        super(Object.class);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public <T> StdDelegatingSerializer(Class<T> cls, Converter<T, ?> converter) {
        super(cls, false);
        this._converter = converter;
        this._delegateType = null;
        this._delegateSerializer = null;
    }

    public StdDelegatingSerializer(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
        super(delegateType);
        this._converter = converter;
        this._delegateType = delegateType;
        this._delegateSerializer = delegateSerializer;
    }

    protected StdDelegatingSerializer withDelegate(Converter<Object, ?> converter, JavaType delegateType, JsonSerializer<?> delegateSerializer) {
        if (this.getClass() != StdDelegatingSerializer.class) {
            throw new IllegalStateException("Sub-class " + this.getClass().getName() + " must override 'withDelegate'");
        }
        return new StdDelegatingSerializer(converter, delegateType, delegateSerializer);
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._delegateSerializer != null && this._delegateSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this._delegateSerializer)).resolve(provider);
        }
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        if (this._delegateSerializer != null) {
            if (this._delegateSerializer instanceof ContextualSerializer) {
                JsonSerializer<?> ser = provider.handleSecondaryContextualization(this._delegateSerializer, property);
                if (ser == this._delegateSerializer) {
                    return this;
                }
                return this.withDelegate(this._converter, this._delegateType, ser);
            }
            return this;
        }
        JavaType delegateType = this._delegateType;
        if (delegateType == null) {
            delegateType = this._converter.getOutputType(provider.getTypeFactory());
        }
        return this.withDelegate(this._converter, delegateType, provider.findValueSerializer(delegateType, property));
    }

    protected Converter<Object, ?> getConverter() {
        return this._converter;
    }

    @Override
    public JsonSerializer<?> getDelegatee() {
        return this._delegateSerializer;
    }

    @Override
    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Object delegateValue = this.convertValue(value);
        if (delegateValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this._delegateSerializer.serialize(delegateValue, jgen, provider);
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        Object delegateValue = this.convertValue(value);
        this._delegateSerializer.serializeWithType(delegateValue, jgen, provider, typeSer);
    }

    @Override
    public boolean isEmpty(Object value) {
        Object delegateValue = this.convertValue(value);
        return this._delegateSerializer.isEmpty(delegateValue);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(provider, typeHint);
        }
        return super.getSchema(provider, typeHint);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint, boolean isOptional) throws JsonMappingException {
        if (this._delegateSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._delegateSerializer)).getSchema(provider, typeHint, isOptional);
        }
        return super.getSchema(provider, typeHint);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._delegateSerializer.acceptJsonFormatVisitor(visitor, typeHint);
    }

    protected Object convertValue(Object value) {
        return this._converter.convert(value);
    }
}

