/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Text;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.io.Writable;
import org.apache.flink.fs.s3presto.shaded.org.apache.hadoop.mapreduce.InputSplit;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CombineFileSplit
extends InputSplit
implements Writable {
    private Path[] paths;
    private long[] startoffset;
    private long[] lengths;
    private String[] locations;
    private long totLength;

    public CombineFileSplit() {
    }

    public CombineFileSplit(Path[] files, long[] start, long[] lengths, String[] locations) {
        this.initSplit(files, start, lengths, locations);
    }

    public CombineFileSplit(Path[] files, long[] lengths) {
        long[] startoffset = new long[files.length];
        for (int i = 0; i < startoffset.length; ++i) {
            startoffset[i] = 0L;
        }
        String[] locations = new String[files.length];
        for (int i = 0; i < locations.length; ++i) {
            locations[i] = "";
        }
        this.initSplit(files, startoffset, lengths, locations);
    }

    private void initSplit(Path[] files, long[] start, long[] lengths, String[] locations) {
        this.startoffset = start;
        this.lengths = lengths;
        this.paths = files;
        this.totLength = 0L;
        this.locations = locations;
        for (long length : lengths) {
            this.totLength += length;
        }
    }

    public CombineFileSplit(CombineFileSplit old) throws IOException {
        this(old.getPaths(), old.getStartOffsets(), old.getLengths(), old.getLocations());
    }

    @Override
    public long getLength() {
        return this.totLength;
    }

    public long[] getStartOffsets() {
        return this.startoffset;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public long getOffset(int i) {
        return this.startoffset[i];
    }

    public long getLength(int i) {
        return this.lengths[i];
    }

    public int getNumPaths() {
        return this.paths.length;
    }

    public Path getPath(int i) {
        return this.paths[i];
    }

    public Path[] getPaths() {
        return this.paths;
    }

    @Override
    public String[] getLocations() throws IOException {
        return this.locations;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int i;
        this.totLength = in.readLong();
        int arrLength = in.readInt();
        this.lengths = new long[arrLength];
        for (int i2 = 0; i2 < arrLength; ++i2) {
            this.lengths[i2] = in.readLong();
        }
        int filesLength = in.readInt();
        this.paths = new Path[filesLength];
        for (i = 0; i < filesLength; ++i) {
            this.paths[i] = new Path(Text.readString(in));
        }
        arrLength = in.readInt();
        this.startoffset = new long[arrLength];
        for (i = 0; i < arrLength; ++i) {
            this.startoffset[i] = in.readLong();
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeLong(this.totLength);
        out.writeInt(this.lengths.length);
        for (long length : this.lengths) {
            out.writeLong(length);
        }
        out.writeInt(this.paths.length);
        for (Path p : this.paths) {
            Text.writeString(out, p.toString());
        }
        out.writeInt(this.startoffset.length);
        for (long length : this.startoffset) {
            out.writeLong(length);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.paths.length; ++i) {
            if (i == 0) {
                sb.append("Paths:");
            }
            sb.append(this.paths[i].toUri().getPath() + ":" + this.startoffset[i] + "+" + this.lengths[i]);
            if (i >= this.paths.length - 1) continue;
            sb.append(",");
        }
        if (this.locations != null) {
            String locs = "";
            StringBuffer locsb = new StringBuffer();
            for (int i = 0; i < this.locations.length; ++i) {
                locsb.append(this.locations[i] + ":");
            }
            locs = locsb.toString();
            sb.append(" Locations:" + locs + "; ");
        }
        return sb.toString();
    }
}

